package io.konig.core.showl;

/*
 * #%L
 * Konig Core
 * %%
 * Copyright (C) 2015 - 2019 Gregory McFall
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


public interface ShowlMappingFilter {
	
	/**
	 * Determine whether a mapping is allowed from source to target.
	 * @param source The source NodeShape
	 * @param target The target NodeShape
	 * @return true if a mapping is allowed from source to target
	 */
	boolean allowMapping(ShowlNodeShape source, ShowlNodeShape target);

}
