package io.konig.shacl;

/*
 * #%L
 * konig-shacl
 * %%
 * Copyright (C) 2015 - 2016 Gregory McFall
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


import java.util.Collection;

import org.openrdf.model.Resource;

public interface ClassManager {
	
	void addLogicalShape(Shape shape);
	
	/**
	 * Get the logical Shape for a specified owl:Class.
	 * @param owlClass The owl:Class whose logical Shape is requested
	 * @return The logical Shape for the given owlClass.
	 */
	Shape getLogicalShape(Resource owlClass);
	
	/**
	 * Get the collection of all known logical Shapes.
	 * @return The collection of all known logical Shapes.
	 */
	Collection<Shape> list();

}
