package io.konig.shacl.io;

/*
 * #%L
 * Konig Core
 * %%
 * Copyright (C) 2015 - 2018 Gregory McFall
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


import org.openrdf.model.Resource;
import org.openrdf.model.vocabulary.RDFS;

import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.io.ResourceFilter;
import io.konig.core.vocab.SH;
import io.konig.core.vocab.Schema;

public class EnumShapeFilter implements ResourceFilter {

	private Graph graph;

	public EnumShapeFilter(Graph graph) {
		this.graph = graph;
	}

	@Override
	public boolean accept(Resource resource) {
		Vertex shape = graph.getVertex(resource);
		Vertex targetClass = shape==null ? null : shape.getVertex(SH.targetClass);
		return targetClass != null && targetClass.hasProperty(RDFS.SUBCLASSOF, Schema.Enumeration);
	}

}
