/*
 * Decompiled with CFR 0.152.
 */
package io.konig.abbrev;

import io.konig.abbrev.Abbreviation;
import io.konig.abbrev.AbbreviationConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class AbbrevTrie
implements Comparable<AbbrevTrie> {
    private String term;
    private Abbreviation abbrev;
    private Map<String, AbbrevTrie> children;

    public AbbrevTrie() {
    }

    public AbbrevTrie(String term) {
        this.term = term;
    }

    public void add(Abbreviation abbrev, String delimiters) {
        String text = abbrev.getPrefLabel();
        AbbrevTrie tail = this.append(this.tokenize(text, delimiters), 0);
        tail.abbrev = abbrev;
    }

    private List<String> tokenize(String text, String delimiters) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, delimiters);
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken().toLowerCase();
            list.add(word);
        }
        return list;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, 0);
        return builder.toString();
    }

    private void append(StringBuilder builder, int indent) {
        this.indent(builder, indent);
        if (this.term != null) {
            builder.append(this.term);
        }
        if (this.abbrev != null) {
            builder.append(" --> ");
            builder.append(this.abbrev.getAbbreviationLabel());
        }
        if (this.term != null) {
            builder.append('\n');
        }
        if (this.children != null) {
            ++indent;
            ArrayList<AbbrevTrie> list = new ArrayList<AbbrevTrie>(this.children.values());
            Collections.sort(list);
            for (AbbrevTrie child : list) {
                child.append(builder, indent);
            }
        }
    }

    private void indent(StringBuilder builder, int indent) {
        for (int i = 0; i < indent * 3; ++i) {
            builder.append(' ');
        }
    }

    public String replaceAll(String text, AbbreviationConfig config) {
        List<Term> termList = this.toTermList(text, config.getDelimiters());
        this.match(termList);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < termList.size()) {
            Term term;
            if (i > 0) {
                builder.append(config.getPreferredDelimiter());
            }
            if ((term = termList.get(i)).abbrev == null) {
                builder.append(term.word);
                ++i;
                continue;
            }
            builder.append(term.abbrev.getAbbreviationLabel());
            i += term.wordCount;
        }
        return builder.toString();
    }

    private AbbrevTrie getChild(String term) {
        return this.children == null ? null : this.children.get(term);
    }

    private void match(List<Term> termList) {
        Term term;
        for (int i = 0; i < termList.size(); i += term.wordCount) {
            term = termList.get(i);
            AbbrevTrie trie = this.getChild(term.word);
            if (trie != null) {
                int j = i;
                while (trie != null) {
                    ++j;
                    if (trie.abbrev != null) {
                        term.abbrev = trie.abbrev;
                        term.wordCount = j - i;
                    }
                    Term next = termList.get(j);
                    trie = trie.getChild(next.word);
                }
            }
            if (term.abbrev != null) continue;
            term.wordCount = 1;
        }
    }

    private List<Term> toTermList(String text, String delimiters) {
        ArrayList<Term> termList = new ArrayList<Term>();
        StringTokenizer tokens = new StringTokenizer(text, delimiters);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().toLowerCase();
            termList.add(new Term(token));
        }
        return termList;
    }

    private AbbrevTrie append(List<String> wordList, int startIndex) {
        AbbrevTrie trie = this;
        for (String word : wordList) {
            AbbrevTrie child = trie.getChild(word);
            if (child == null) {
                child = new AbbrevTrie(word);
                if (trie.children == null) {
                    trie.children = new HashMap<String, AbbrevTrie>();
                }
                trie.children.put(word, child);
            }
            trie = child;
        }
        return trie;
    }

    @Override
    public int compareTo(AbbrevTrie o) {
        return this.term.compareTo(o.term);
    }

    private static class Term {
        private String word;
        private int wordCount = 0;
        private Abbreviation abbrev;

        public Term(String word) {
            this.word = word;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Term[word: ");
            builder.append(this.word);
            if (this.abbrev != null) {
                builder.append(", abbrev: ");
                builder.append(this.abbrev.getAbbreviationLabel());
            }
            builder.append(", wordCount: ");
            builder.append(this.wordCount);
            builder.append(']');
            return builder.toString();
        }
    }
}

