/*
 * Decompiled with CFR 0.152.
 */
package io.konig.abbrev;

import io.konig.abbrev.AbbreviationScheme;
import java.util.StringTokenizer;
import org.openrdf.model.URI;

public class Abbreviation {
    private URI id;
    private String prefLabel;
    private String abbreviationLabel;
    private AbbreviationScheme inScheme;

    public Abbreviation() {
    }

    public Abbreviation(URI id) {
        this.id = id;
    }

    public URI getId() {
        return this.id;
    }

    public void setId(URI id) {
        this.id = id;
    }

    public String getPrefLabel() {
        return this.prefLabel;
    }

    public void setPrefLabel(String prefLabel) {
        this.prefLabel = prefLabel;
    }

    public static String normalize(String text) {
        StringTokenizer tokens = new StringTokenizer(text, " \t\r\n");
        StringBuilder builder = new StringBuilder(text.length());
        String space = "";
        while (tokens.hasMoreTokens()) {
            builder.append(space);
            space = " ";
            String word = tokens.nextToken().toLowerCase();
            builder.append(word);
        }
        return builder.toString();
    }

    public String getAbbreviationLabel() {
        return this.abbreviationLabel;
    }

    public void setAbbreviationLabel(String abbreviationLabel) {
        this.abbreviationLabel = abbreviationLabel;
    }

    public AbbreviationScheme getInScheme() {
        return this.inScheme;
    }

    public void setInScheme(AbbreviationScheme inScheme) {
        this.inScheme = inScheme;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Abbreviation[prefLabel: \"");
        builder.append(this.prefLabel);
        builder.append("\", abbreviationLabel: \"");
        builder.append(this.abbreviationLabel);
        builder.append("\"]");
        return builder.toString();
    }
}

