/*
 * Decompiled with CFR 0.152.
 */
package io.konig.abbrev;

import io.konig.abbrev.AbbrevTrie;
import io.konig.abbrev.Abbreviation;
import io.konig.abbrev.AbbreviationConfig;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.URI;

public class AbbreviationScheme {
    private URI id;
    private Map<String, Abbreviation> map = new HashMap<String, Abbreviation>();
    private AbbrevTrie trie = new AbbrevTrie();
    private AbbreviationConfig config;

    public AbbreviationScheme(URI id, AbbreviationConfig config) {
        this.id = id;
        this.config = config;
    }

    public URI getId() {
        return this.id;
    }

    public void add(Abbreviation abbrev) {
        abbrev.setInScheme(this);
        this.map.put(abbrev.getPrefLabel(), abbrev);
        this.trie.add(abbrev, this.config.getDelimiters());
    }

    public String abbreviate(String text) {
        return this.trie.replaceAll(text, this.config);
    }

    public Abbreviation getAbbreviationByPrefLabel(String prefLabel) {
        return this.map.get(prefLabel);
    }
}

