/*
 * Decompiled with CFR 0.152.
 */
package io.konig.abbrev;

import io.konig.abbrev.Abbreviation;
import io.konig.abbrev.AbbreviationConfig;
import io.konig.abbrev.AbbreviationManager;
import io.konig.abbrev.AbbreviationScheme;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.vocab.Konig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.SKOS;

public class MemoryAbbreviationManager
implements AbbreviationManager {
    private Graph graph;
    private Map<URI, AbbreviationScheme> map = new HashMap<URI, AbbreviationScheme>();
    private AbbreviationConfig config;

    public MemoryAbbreviationManager(Graph graph, AbbreviationConfig config) {
        this.graph = graph;
        this.config = config;
    }

    @Override
    public AbbreviationScheme getSchemeById(URI schemeId) {
        AbbreviationScheme scheme = this.map.get(schemeId);
        if (scheme == null) {
            scheme = new AbbreviationScheme(schemeId, this.config);
            this.map.put(schemeId, scheme);
            this.load(scheme);
        }
        return scheme;
    }

    private void load(AbbreviationScheme scheme) {
        Vertex schemeVertex = this.graph.getVertex((Resource)scheme.getId());
        if (schemeVertex != null) {
            List<Vertex> conceptList = schemeVertex.asTraversal().in(SKOS.IN_SCHEME).toVertexList();
            for (Vertex concept : conceptList) {
                Abbreviation abbrev = this.parseAbbreviation(concept);
                scheme.add(abbrev);
            }
        }
    }

    private Abbreviation parseAbbreviation(Vertex concept) {
        Value prefLabel = concept.getValue(SKOS.PREF_LABEL);
        if (prefLabel == null) {
            throw new KonigException("skos:prefLabel is not defined for abbreviation <" + concept.getId().stringValue() + ">");
        }
        Value abbrevLabel = concept.getValue(Konig.abbreviationLabel);
        if (abbrevLabel == null) {
            throw new KonigException("konig:abbreviationLabel is not defined for abbreviation <" + concept.getId().stringValue() + ">");
        }
        if (!(concept.getId() instanceof URI)) {
            throw new KonigException("Abbreviation concept '" + prefLabel + "' must be identified by a URI");
        }
        URI id = (URI)concept.getId();
        Abbreviation result = new Abbreviation(id);
        result.setPrefLabel(prefLabel.stringValue());
        result.setAbbreviationLabel(abbrevLabel.stringValue());
        return result;
    }
}

