/*
 * Decompiled with CFR 0.152.
 */
package io.konig.activity;

import io.konig.core.impl.UidGeneratorImpl;
import java.util.Calendar;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class Activity {
    private Resource id;
    private URI type;
    private URI actor;
    private URI instrument;
    private Calendar endTime;

    public static URI nextActivityId() {
        String value = "http://www.konig.io/activity/" + UidGeneratorImpl.getInstance().next();
        return new URIImpl(value);
    }

    public Activity() {
    }

    public Activity(Resource id) {
        this.id = id;
    }

    public Resource getId() {
        return this.id;
    }

    public void setId(Resource id) {
        this.id = id;
    }

    public URI getActor() {
        return this.actor;
    }

    public void setActor(URI actor) {
        this.actor = actor;
    }

    public URI getInstrument() {
        return this.instrument;
    }

    public void setInstrument(URI instrument) {
        this.instrument = instrument;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public void instrument(Class<?> javaClass) {
        URIImpl uri = new URIImpl("http://www.konig.io/ns/java/" + javaClass.getName());
        this.setInstrument((URI)uri);
    }

    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Activity [\n");
        if (this.type != null) {
            builder.append("  type: ");
            builder.append(this.type.stringValue());
            builder.append("\n");
        }
        if (this.id != null) {
            builder.append("  id: ");
            builder.append(this.id.stringValue());
            builder.append("\n");
        }
        builder.append("]");
        return builder.toString();
    }
}

