/*
 * Decompiled with CFR 0.152.
 */
package io.konig.cadl;

import io.konig.annotation.RdfProperty;
import io.konig.cadl.CadlEntity;
import io.konig.cadl.Dimension;
import io.konig.cadl.Measure;
import io.konig.cadl.Variable;
import io.konig.core.vocab.CADL;
import io.konig.datasource.DataSource;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.URI;

public class Cube
extends CadlEntity {
    private Variable source;
    private Set<Dimension> dimension = new LinkedHashSet<Dimension>();
    private Set<Measure> measure = new LinkedHashSet<Measure>();
    private Set<DataSource> storage = new LinkedHashSet<DataSource>();

    @Override
    public URI getType() {
        return CADL.Cube;
    }

    public void addStorage(DataSource ds) {
        this.storage.add(ds);
    }

    @RdfProperty(value="http://www.konig.io/ns/cadl/storage")
    public Set<DataSource> getStorage() {
        return this.storage;
    }

    @RdfProperty(value="http://www.konig.io/ns/cadl/source")
    public Variable getSource() {
        return this.source;
    }

    public void setSource(Variable source) {
        this.source = source;
    }

    public Dimension findDimensionByName(String localName) {
        for (Dimension d : this.dimension) {
            if (!localName.equals(d.getId().getLocalName())) continue;
            return d;
        }
        return null;
    }

    public Dimension findDimensionById(URI id) {
        for (Dimension d : this.dimension) {
            if (!id.equals((Object)d.getId())) continue;
            return d;
        }
        return null;
    }

    public void addDimension(Dimension dimension) {
        this.dimension.add(dimension);
    }

    @RdfProperty(value="http://www.konig.io/ns/cadl/dimension")
    public Set<Dimension> getDimension() {
        return this.dimension;
    }

    public void addMeasure(Measure measure) {
        this.measure.add(measure);
    }

    @RdfProperty(value="http://www.konig.io/ns/cadl/measure")
    public Set<Measure> getMeasure() {
        return this.measure;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Cube cube = new Cube();

        private Builder() {
        }

        public Builder id(URI id) {
            this.cube.setId(id);
            return this;
        }

        public Builder dimension(Dimension dim) {
            this.cube.addDimension(dim);
            return this;
        }

        public Builder measure(Measure measure) {
            this.cube.addMeasure(measure);
            return this;
        }

        public Builder source(Variable source) {
            this.cube.setSource(source);
            return this;
        }

        public Cube build() {
            return this.cube;
        }
    }
}

