/*
 * Decompiled with CFR 0.152.
 */
package io.konig.cadl;

import io.konig.cadl.Cube;
import io.konig.cadl.CubeManager;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.RdfUtil;
import io.konig.core.io.BaseDirectiveHandler;
import io.konig.core.io.Emitter;
import io.konig.core.io.TurtleConfig;
import io.konig.core.pojo.EmitContext;
import io.konig.core.pojo.SimplePojoEmitter;
import io.konig.core.vocab.CADL;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFHandlerException;

public class CubeEmitter
implements Emitter {
    private File outDir;
    private CubeManager cubeManager;

    public CubeEmitter(File outDir, CubeManager cubeManager) {
        this.outDir = outDir;
        this.cubeManager = cubeManager;
    }

    @Override
    public void emit(Graph graph) throws IOException, KonigException {
        SimplePojoEmitter emitter = SimplePojoEmitter.getInstance();
        Map<String, CubeNamespace> map = this.buildMap(graph.getNamespaceManager());
        for (CubeNamespace ns : map.values()) {
            this.write(ns, emitter, graph.getNamespaceManager());
        }
    }

    private void write(CubeNamespace ns, SimplePojoEmitter emitter, NamespaceManager nsManager) throws IOException {
        MemoryGraph graph = new MemoryGraph(nsManager);
        EmitContext context = new EmitContext(graph);
        context.addIriReference(CADL.rollUpTo);
        for (Cube cube : ns.getCubeList()) {
            emitter.emit(cube, graph);
        }
        this.outDir.mkdirs();
        TurtleConfig config = new TurtleConfig();
        config.setBaseDirectiveHandler(new CubeBaseDirectiveHandler(this.cubeManager));
        File outFile = new File(this.outDir, ns.getNamespace().getPrefix() + ".ttl");
        try (FileWriter writer = new FileWriter(outFile);){
            RdfUtil.prettyPrintTurtle(graph.getNamespaceManager(), null, graph, writer, config);
        }
        catch (RDFHandlerException e) {
            throw new KonigException(e);
        }
    }

    private Map<String, CubeNamespace> buildMap(NamespaceManager nsManager) {
        HashMap<String, CubeNamespace> map = new HashMap<String, CubeNamespace>();
        for (Cube cube : this.cubeManager.listCubes()) {
            URI cubeId = cube.getId();
            String namespaceName = cubeId.getNamespace();
            Namespace namespace = nsManager.findByName(namespaceName);
            if (namespace == null) {
                throw new KonigException("Namespace prefix not found for namespace " + namespaceName);
            }
            CubeNamespace cn = (CubeNamespace)map.get(namespaceName);
            if (cn == null) {
                cn = new CubeNamespace(namespace);
                map.put(namespaceName, cn);
            }
            cn.addCube(cube);
        }
        return map;
    }

    private static class CubeBaseDirectiveHandler
    implements BaseDirectiveHandler {
        private CubeManager manager;

        public CubeBaseDirectiveHandler(CubeManager manager) {
            this.manager = manager;
        }

        @Override
        public String injectBaseDirective(URI resource) {
            return this.manager.findById(resource) != null ? resource.stringValue() + "/" : null;
        }
    }

    private static class CubeNamespace {
        private Namespace namespace;
        private List<Cube> cubeList = new ArrayList<Cube>();

        public CubeNamespace(Namespace namespace) {
            this.namespace = namespace;
        }

        void addCube(Cube cube) {
            this.cubeList.add(cube);
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public List<Cube> getCubeList() {
            return this.cubeList;
        }
    }
}

