/*
 * Decompiled with CFR 0.152.
 */
package io.konig.cadl;

import io.konig.cadl.Cube;
import io.konig.cadl.Variable;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeReasoner {
    private static Logger logger = LoggerFactory.getLogger(CubeReasoner.class);
    private ShowlManager showlManager;
    private Map<String, Set<ShowlClass>> classesByLocalName;

    public CubeReasoner(ShowlManager classManager) {
        this.showlManager = classManager;
    }

    public void visit(Cube cube) {
        this.buildMap();
        this.setSourceType(cube);
    }

    private void setSourceType(Cube cube) {
        String key;
        Set<ShowlClass> set;
        Variable source;
        URI sourceId;
        if (cube.getSource().getValueType() == null && (sourceId = (source = cube.getSource()).getId()) != null && (set = this.classesByLocalName.get(key = sourceId.getLocalName().toLowerCase())) != null && set.size() == 1) {
            URI classId = set.iterator().next().getId();
            source.setValueType(classId);
            if (logger.isTraceEnabled()) {
                logger.trace("setSourceType - Set {} as Value Type of {}", this.curie(classId), (Object)sourceId);
            }
        }
    }

    private Object curie(URI id) {
        return RdfUtil.optionalCurie(this.showlManager.getReasoner().getGraph().getNamespaceManager(), id);
    }

    private void buildMap() {
        if (this.classesByLocalName == null) {
            this.classesByLocalName = new HashMap<String, Set<ShowlClass>>();
            for (ShowlClass owlClass : this.showlManager.listClasses()) {
                URI classId = owlClass.getId();
                String key = classId.getLocalName().toLowerCase();
                Set<ShowlClass> set = this.classesByLocalName.get(key);
                if (set == null) {
                    set = new HashSet<ShowlClass>();
                    this.classesByLocalName.put(key, set);
                }
                set.add(owlClass);
            }
        }
    }
}

