/*
 * Decompiled with CFR 0.152.
 */
package io.konig.cadl;

import io.konig.cadl.Attribute;
import io.konig.cadl.Cube;
import io.konig.cadl.CubeShapeException;
import io.konig.cadl.CubeUtil;
import io.konig.cadl.Dimension;
import io.konig.cadl.Level;
import io.konig.cadl.Variable;
import io.konig.core.OwlReasoner;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlManager;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlTraverser;
import io.konig.datasource.DataSource;
import io.konig.formula.DirectionStep;
import io.konig.formula.Formula;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.FunctionExpression;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PathTerm;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.formula.VariableTerm;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeShapeBuilder {
    private static Logger logger = LoggerFactory.getLogger(CubeShapeBuilder.class);
    private ShapeManager shapeManager;
    private OwlReasoner reasoner;
    private String shapeNamespace;

    public CubeShapeBuilder(OwlReasoner reasoner, ShapeManager shapeManager, String shapeNamespace) {
        this.reasoner = reasoner;
        this.shapeManager = shapeManager;
        this.shapeNamespace = shapeNamespace;
    }

    public Shape buildShape(Cube cube) throws CubeShapeException {
        Worker worker = new Worker();
        return worker.buildShape(cube);
    }

    private class Worker {
        private ShowlTraverser traverser;
        private PropertyConstraint sourceVariable;
        private String sourceVarName;

        private Worker() {
        }

        public Shape buildShape(Cube cube) throws CubeShapeException {
            if (logger.isDebugEnabled()) {
                logger.debug("buildShape({})", (Object)cube.getId());
            }
            ShowlManager showlManager = new ShowlManager(CubeShapeBuilder.this.shapeManager, CubeShapeBuilder.this.reasoner);
            this.traverser = new ShowlTraverser(showlManager);
            URI shapeId = this.uri(CubeShapeBuilder.this.shapeNamespace + cube.getId().getLocalName() + "RawShape");
            Shape shape = this.produceShape(shapeId);
            shape.setNodeShapeCube(cube);
            this.addVariable(shape, cube, cube.getSource());
            ArrayList<PathStep> location = new ArrayList<PathStep>();
            for (Dimension dim : cube.getDimension()) {
                location.clear();
                this.rewriteFormula(location, dim.getFormula());
                for (Level level : dim.getLevel()) {
                    this.addLevel(location, shape, cube, dim, level);
                }
            }
            this.addDataSources(shape, cube);
            return shape;
        }

        private void addDataSources(Shape shape, Cube cube) {
            for (DataSource ds : cube.getStorage()) {
                shape.addShapeDataSource(ds);
            }
        }

        private void addVariable(Shape shape, Cube cube, Variable source) {
            PropertyConstraint p = shape.getVariableById(source.getId());
            if (p == null) {
                URI predicate = CubeUtil.predicate(cube, source.getId());
                p = new PropertyConstraint(predicate);
                shape.addVariable(p);
                if (logger.isTraceEnabled()) {
                    logger.trace("addVariable: {}", (Object)p.getPredicate().stringValue());
                }
            }
            p.setValueClass((Resource)source.getValueType());
            this.sourceVariable = p;
            this.sourceVarName = "?" + p.getPredicate().getLocalName();
            shape.setTargetClass(this.targetClass(cube));
            if (logger.isTraceEnabled()) {
                logger.trace("addVariable: On {}, targetClass = {}", (Object)RdfUtil.localName(shape.getId()), (Object)RdfUtil.localName((Resource)shape.getTargetClass()));
            }
        }

        private URI targetClass(Cube cube) {
            return RdfUtil.uri((Value)this.sourceVariable.getValueClass());
        }

        private void addLevel(List<PathStep> location, Shape shape, Cube cube, Dimension dim, Level level) throws CubeShapeException {
            URI predicate;
            PropertyConstraint p;
            if (logger.isTraceEnabled()) {
                logger.trace("addLevel(shape: {}, level: {})", (Object)RdfUtil.localName(shape.getId()), (Object)RdfUtil.localName((Resource)level.getId()));
            }
            if ((p = shape.getPropertyConstraint(predicate = CubeUtil.predicate(cube, level.getId()))) == null) {
                p = new PropertyConstraint(predicate);
                shape.add(p);
            }
            p.setMinCount(0);
            p.setMaxCount(1);
            this.setLevelFormula(location, dim, level, p);
            if (!level.getAttribute().isEmpty()) {
                this.setLevelValueClass(location, dim, level, p);
                URI levelShapeId = this.uri(CubeShapeBuilder.this.shapeNamespace + cube.getId().getLocalName() + "RawShape/level/" + level.getId().getLocalName() + "Shape");
                Shape levelShape = this.produceShape(levelShapeId);
                p.setShape(levelShape);
                this.addAttributes(levelShape, cube, level, p, location);
            } else {
                this.setDatatype(p, p.getFormula(), level.getId());
            }
        }

        private void setLevelValueClass(List<PathStep> location, Dimension dim, Level level, PropertyConstraint p) throws CubeShapeException {
            QuantifiedExpression formula = p.getFormula();
            Set<URI> valueClassCandidates = this.traverser.valueClass(RdfUtil.uri((Value)this.sourceVariable.getValueClass()), formula);
            if (valueClassCandidates.size() == 1) {
                p.setValueClass((Resource)valueClassCandidates.iterator().next());
                if (logger.isTraceEnabled()) {
                    logger.trace("setLevelValueClass: level={}, valueClass={}", (Object)level.getId().getLocalName(), (Object)RdfUtil.localName(p.getValueClass()));
                }
            } else {
                throw new CubeShapeException("Failed to determine valueClass for level " + level.getId().stringValue());
            }
        }

        private void addAttributes(Shape shape, Cube cube, Level level, PropertyConstraint levelConstraint, List<PathStep> location) throws CubeShapeException {
            if (logger.isTraceEnabled()) {
                logger.debug("addAttributes(shape: {}, level: {})", (Object)RdfUtil.localName(shape.getId()), (Object)level.getId().getLocalName());
            }
            URI datatype = null;
            for (Attribute attr : level.getAttribute()) {
                if (attr.getId().getLocalName().equals("id")) {
                    shape.setNodeKind(NodeKind.IRI);
                    continue;
                }
                URI predicate = null;
                if (attr.getFormula() == null) {
                    URI levelClass = RdfUtil.uri((Value)levelConstraint.getValueClass());
                    if (levelClass == null) {
                        throw new CubeShapeException("Target class not defined for level: " + level.getId().stringValue());
                    }
                    String localName = attr.getId().getLocalName();
                    ShowlPropertyShape property = this.traverser.findPropertyByLocalName(levelClass, localName);
                    if (property == null) {
                        throw new CubeShapeException("Property not found for attribute: " + attr.getId().stringValue());
                    }
                    predicate = property.getPredicate();
                    datatype = this.datatype(property);
                    if (logger.isTraceEnabled()) {
                        logger.trace("addAttributes: At level {}, added direct attribute {}", (Object)level.getId().getLocalName(), (Object)predicate.stringValue());
                    }
                } else {
                    predicate = CubeUtil.predicate(cube, attr.getId());
                }
                PropertyConstraint p = shape.getPropertyConstraint(predicate);
                if (p == null) {
                    p = new PropertyConstraint(predicate);
                    shape.add(p);
                }
                QuantifiedExpression formula = this.rewriteFormula(location, attr.getFormula());
                if (logger.isTraceEnabled() && formula != null) {
                    logger.trace("addAttributes: level={}, attribute={}, formula={}", new Object[]{level.getId().getLocalName(), attr.getId().getLocalName(), formula.toSimpleString()});
                }
                p.setFormula(formula);
                p.setMinCount(0);
                p.setMaxCount(1);
                if (datatype != null) {
                    p.setDatatype(datatype);
                }
                if (p.getDatatype() != null) continue;
                this.setDatatype(p, formula, attr.getId());
            }
        }

        private URI datatype(ShowlPropertyShape property) {
            PropertyConstraint constraint = property.getPropertyConstraint();
            if (constraint != null && constraint.getDatatype() != null) {
                return constraint.getDatatype();
            }
            ShowlProperty p = property.getProperty();
            if (p != null) {
                if (p.getRange() != null) {
                    return p.getRange().getId();
                }
                ShowlClass owlClass = p.inferRange(this.traverser.getManager().getShowlFactory());
                if (owlClass != null) {
                    return owlClass.getId();
                }
            }
            return null;
        }

        private QuantifiedExpression rewriteFormula(List<PathStep> location, QuantifiedExpression formula) {
            if (formula != null) {
                String oldFormulaText = null;
                if (logger.isTraceEnabled()) {
                    oldFormulaText = formula.toSimpleString();
                }
                formula = formula.clone();
                final ArrayList pathList = new ArrayList();
                formula.dispatch(new FormulaVisitor(){

                    @Override
                    public void enter(Formula formula) {
                        if (formula instanceof PathExpression) {
                            pathList.add((PathExpression)formula);
                        }
                    }

                    @Override
                    public void exit(Formula formula) {
                    }
                });
                for (PathExpression path : pathList) {
                    if (!this.startsWithVariable(path)) continue;
                    List<PathStep> stepList = path.getStepList();
                    if (location.isEmpty()) {
                        stepList.remove(0);
                        location.addAll(stepList);
                        continue;
                    }
                    for (int i = 0; i < location.size(); ++i) {
                        stepList.remove(0);
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("rewriteFormula: {} ===> {}", (Object)oldFormulaText, (Object)formula.toSimpleString());
                }
            }
            return formula;
        }

        private boolean startsWithVariable(PathExpression path) {
            PathStep step;
            List<PathStep> stepList = path.getStepList();
            if (!stepList.isEmpty() && (step = stepList.get(0)) instanceof DirectionStep) {
                DirectionStep dirStep = (DirectionStep)step;
                PathTerm term = dirStep.getTerm();
                return term instanceof VariableTerm;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setDatatype(PropertyConstraint p, QuantifiedExpression formula, URI elementId) throws CubeShapeException {
            if (formula == null) {
                throw new CubeShapeException(MessageFormat.format("Formula must be defined for <{0}>", elementId.stringValue()));
            }
            PrimaryExpression primary = formula.asPrimaryExpression();
            if (primary instanceof FunctionExpression) {
                FunctionExpression func = (FunctionExpression)primary;
                URI datatype = func.getModel().getReturnType().getRdfType();
                p.setDatatype(datatype);
                if (!logger.isTraceEnabled()) return;
                logger.trace("setDatatype: type={} at {}", (Object)datatype.getLocalName(), (Object)elementId.stringValue());
                return;
            }
            Set<ShowlProperty> propertySet = this.traverser.traverse(this.sourceVariable.getPredicate(), RdfUtil.uri((Value)this.sourceVariable.getValueClass()), formula);
            if (propertySet.size() == 1) {
                this.setDatatype(propertySet.iterator().next(), p, elementId, formula);
                return;
            } else {
                if (propertySet.isEmpty()) {
                    throw new CubeShapeException(MessageFormat.format("Datatype not found for <{0}> mapped by {1}", elementId.stringValue(), formula.toSimpleString()));
                }
                HashSet<URI> datatypeSet = new HashSet<URI>();
                for (ShowlProperty property : propertySet) {
                    datatypeSet.addAll(property.rangeIncludes(CubeShapeBuilder.this.reasoner));
                }
                if (datatypeSet.size() == 1) {
                    URI datatype = (URI)datatypeSet.iterator().next();
                    if (!CubeShapeBuilder.this.reasoner.isDatatype((Resource)datatype)) throw new CubeShapeException(MessageFormat.format("<{0}> must have a Datatype value, but the formula {1} implies <{2}>", elementId.stringValue(), formula.toSimpleString(), datatype.stringValue()));
                    p.setDatatype(datatype);
                    if (!logger.isTraceEnabled()) return;
                    logger.trace("setDatatype: type={} at {}", (Object)datatype.getLocalName(), (Object)elementId.stringValue());
                    return;
                } else {
                    if (datatypeSet.isEmpty()) {
                        throw new CubeShapeException(MessageFormat.format("Datatype for <{0}> is not known.  The datatype must be specified explicitly.", elementId.stringValue()));
                    }
                    StringBuilder msg = new StringBuilder();
                    msg.append("Datatype is ambiguous for <");
                    msg.append(elementId.stringValue());
                    msg.append(">.  The datatype must be specified explicitly.");
                    throw new CubeShapeException(msg.toString());
                }
            }
        }

        private void setDatatype(ShowlProperty property, PropertyConstraint p, URI element, QuantifiedExpression formula) throws CubeShapeException {
            ShowlClass range = property.getRange();
            URI datatype = null;
            if (range == null) {
                Set<URI> set = property.rangeIncludes(CubeShapeBuilder.this.reasoner);
                if (set.size() == 1) {
                    datatype = set.iterator().next();
                } else if (set.size() > 1) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Datatype is ambiguous for <");
                    msg.append(element.stringValue());
                    msg.append(">.  The datatype must be specified explicitly.");
                    throw new CubeShapeException(msg.toString());
                }
            } else {
                datatype = range.getId();
            }
            if (datatype == null) {
                throw new CubeShapeException(MessageFormat.format("Datatype for <{0}> is not known.  The datatype must be specified explicitly.", element.stringValue()));
            }
            if (!CubeShapeBuilder.this.reasoner.isDatatype((Resource)datatype)) {
                throw new CubeShapeException(MessageFormat.format("<{0}> must have a Datatype value, but the formula {1} implies <{2}>", element.stringValue(), formula.toSimpleString(), datatype.stringValue()));
            }
            p.setDatatype(datatype);
        }

        private Shape produceShape(URI shapeId) {
            Shape shape = CubeShapeBuilder.this.shapeManager.getShapeById((Resource)shapeId);
            if (shape == null) {
                shape = new Shape((Resource)shapeId);
                CubeShapeBuilder.this.shapeManager.addShape(shape);
            }
            return shape;
        }

        private void setLevelFormula(List<PathStep> location, Dimension dim, Level level, PropertyConstraint p) {
            QuantifiedExpression formula = this.rewriteFormula(location, level.getFormula());
            p.setFormula(formula);
            if (formula != null && logger.isTraceEnabled()) {
                logger.trace("At Dimension {}, Level {}... formula = {}", new Object[]{dim.getId().getLocalName(), level.getId().getLocalName(), formula.toSimpleString()});
            }
        }

        private URI uri(String value) {
            return new URIImpl(value);
        }
    }
}

