/*
 * Decompiled with CFR 0.152.
 */
package io.konig.cadl;

import io.konig.annotation.RdfProperty;
import io.konig.cadl.CadlEntity;
import io.konig.cadl.Level;
import io.konig.core.vocab.CADL;
import io.konig.formula.FormulaParser;
import io.konig.formula.QuantifiedExpression;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFParseException;

public class Dimension
extends CadlEntity {
    public Set<Level> level = new LinkedHashSet<Level>();
    private QuantifiedExpression formula;

    @Override
    public URI getType() {
        return CADL.Dimension;
    }

    public QuantifiedExpression getFormula() {
        return this.formula;
    }

    public void setFormula(QuantifiedExpression formula) {
        this.formula = formula;
    }

    public void addLevel(Level level) {
        this.level.add(level);
    }

    public Level findLevelByName(String localName) {
        for (Level e : this.level) {
            if (!localName.equals(e.getId().getLocalName())) continue;
            return e;
        }
        return null;
    }

    public Level findLevelById(URI id) {
        for (Level e : this.level) {
            if (!id.equals((Object)e.getId())) continue;
            return e;
        }
        return null;
    }

    @RdfProperty(value="http://www.konig.io/ns/cadl/level")
    public Set<Level> getLevel() {
        return this.level;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Dimension dimension = new Dimension();

        private Builder() {
        }

        public Builder formula(String text, URI ... term) throws RDFParseException, IOException {
            FormulaParser parser = new FormulaParser();
            this.dimension.setFormula(parser.quantifiedExpression(text, term));
            return this;
        }

        public Builder id(URI id) {
            this.dimension.setId(id);
            return this;
        }

        public Builder level(Level level) {
            this.dimension.addLevel(level);
            return this;
        }

        public Dimension build() {
            return this.dimension;
        }
    }
}

