/*
 * Decompiled with CFR 0.152.
 */
package io.konig.cadl;

import io.konig.annotation.RdfProperty;
import io.konig.cadl.Attribute;
import io.konig.cadl.CadlEntity;
import io.konig.cadl.HasFormula;
import io.konig.core.KonigException;
import io.konig.core.impl.SimpleLocalNameService;
import io.konig.core.vocab.CADL;
import io.konig.formula.FormulaParser;
import io.konig.formula.QuantifiedExpression;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFParseException;

public class Level
extends CadlEntity
implements HasFormula {
    private Set<Level> rollUpTo;
    private QuantifiedExpression formula;
    private Set<Attribute> attribute;

    @Override
    public URI getType() {
        return CADL.Level;
    }

    public void addAttribute(Attribute a) {
        if (this.attribute == null) {
            this.attribute = new LinkedHashSet<Attribute>();
        }
        this.attribute.add(a);
    }

    public Attribute findAttributeByName(String localName) {
        for (Attribute a : this.attribute) {
            if (!localName.equals(a.getId().getLocalName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findAttributeById(URI id) {
        for (Attribute a : this.attribute) {
            if (!id.equals((Object)a.getId())) continue;
            return a;
        }
        return null;
    }

    @RdfProperty(value="http://www.konig.io/ns/cadl/attribute")
    public Set<Attribute> getAttribute() {
        return this.attribute == null ? Collections.emptySet() : this.attribute;
    }

    @RdfProperty(value="http://www.konig.io/ns/cadl/rollUpTo")
    public Set<Level> getRollUpTo() {
        return this.rollUpTo == null ? Collections.emptySet() : this.rollUpTo;
    }

    public void addRollUpTo(Level rollUpTo) {
        if (this.rollUpTo == null) {
            this.rollUpTo = new LinkedHashSet<Level>();
        }
        this.rollUpTo.add(rollUpTo);
    }

    @Override
    @RdfProperty(value="http://www.konig.io/ns/cadl/formula")
    public QuantifiedExpression getFormula() {
        return this.formula;
    }

    @Override
    public void setFormula(QuantifiedExpression formula) {
        this.formula = formula;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Level level = new Level();

        private Builder() {
        }

        public Builder id(URI id) {
            this.level.setId(id);
            return this;
        }

        public Builder formula(String text, URI ... term) {
            SimpleLocalNameService service = new SimpleLocalNameService();
            for (URI iri : term) {
                service.add(iri);
            }
            FormulaParser parser = new FormulaParser(null, service);
            try {
                QuantifiedExpression formula = parser.quantifiedExpression(text);
                this.level.setFormula(formula);
            }
            catch (IOException | RDFParseException e) {
                throw new KonigException(e);
            }
            return this;
        }

        public Builder rollUpTo(Level broader) {
            this.level.addRollUpTo(broader);
            return this;
        }

        public Level build() {
            return this.level;
        }
    }
}

