/*
 * Decompiled with CFR 0.152.
 */
package io.konig.cadl;

import io.konig.annotation.RdfProperty;
import io.konig.cadl.CadlEntity;
import io.konig.cadl.HasFormula;
import io.konig.core.KonigException;
import io.konig.core.impl.SimpleLocalNameService;
import io.konig.core.vocab.CADL;
import io.konig.formula.FormulaParser;
import io.konig.formula.QuantifiedExpression;
import java.io.IOException;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFParseException;

public class Measure
extends CadlEntity
implements HasFormula {
    private QuantifiedExpression formula;

    @Override
    @RdfProperty(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    public URI getType() {
        return CADL.Measure;
    }

    @Override
    @RdfProperty(value="http://www.konig.io/ns/cadl/formula")
    public QuantifiedExpression getFormula() {
        return this.formula;
    }

    @Override
    public void setFormula(QuantifiedExpression formula) {
        this.formula = formula;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private URI id;
        private QuantifiedExpression formula;

        private Builder() {
        }

        public Builder id(URI id) {
            this.id = id;
            return this;
        }

        public Builder formula(String text, URI ... term) {
            SimpleLocalNameService service = new SimpleLocalNameService();
            for (URI iri : term) {
                service.add(iri);
            }
            FormulaParser parser = new FormulaParser(null, service);
            try {
                this.formula = parser.quantifiedExpression(text);
            }
            catch (IOException | RDFParseException e) {
                throw new KonigException(e);
            }
            return this;
        }

        public Measure build() {
            Measure m = new Measure();
            m.setId(this.id);
            m.setFormula(this.formula);
            return m;
        }
    }
}

