/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.Vertex;
import java.util.Collection;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class AmbiguousPreferredClassException
extends Exception {
    private static final long serialVersionUID = 1L;

    public AmbiguousPreferredClassException(String message) {
        super(message);
    }

    public AmbiguousPreferredClassException(Collection<Vertex> collection) {
        super(AmbiguousPreferredClassException.createMessage(collection));
    }

    private static String createMessage(Collection<Vertex> collection) {
        StringBuilder builder = new StringBuilder("The following classes are ambiguous, but no preferred class is defined:");
        for (Vertex v : collection) {
            builder.append(' ');
            Resource id = v.getId();
            if (id instanceof URI) {
                builder.append(((URI)id).getLocalName());
                continue;
            }
            builder.append(id.stringValue());
        }
        return builder.toString();
    }
}

