/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Vertex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;

public class DepthFirstEdgeIterable
implements Iterable<Edge> {
    private Graph graph;
    private Edge current = null;
    private List<Iterator<Edge>> stack = new ArrayList<Iterator<Edge>>();

    public DepthFirstEdgeIterable(Graph graph) {
        this.graph = graph;
    }

    private Iterator<Edge> peek() {
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    private Iterator<Edge> pop() {
        return this.stack.isEmpty() ? null : this.stack.remove(this.stack.size() - 1);
    }

    @Override
    public Iterator<Edge> iterator() {
        this.stack.add(this.graph.iterator());
        return new EdgeIterator();
    }

    class EdgeIterator
    implements Iterator<Edge> {
        public EdgeIterator() {
            this.next();
        }

        @Override
        public boolean hasNext() {
            return DepthFirstEdgeIterable.this.current != null;
        }

        @Override
        public Edge next() {
            Edge result = DepthFirstEdgeIterable.this.current;
            DepthFirstEdgeIterable.this.current = null;
            while (DepthFirstEdgeIterable.this.current == null && !DepthFirstEdgeIterable.this.stack.isEmpty()) {
                Iterator sequence = DepthFirstEdgeIterable.this.peek();
                if (sequence.hasNext()) {
                    DepthFirstEdgeIterable.this.current = (Edge)sequence.next();
                    Value object = DepthFirstEdgeIterable.this.current.getObject();
                    Resource subject = DepthFirstEdgeIterable.this.current.getSubject();
                    if (subject instanceof BNode && DepthFirstEdgeIterable.this.stack.size() == 1) {
                        DepthFirstEdgeIterable.this.current = null;
                        continue;
                    }
                    if (!(object instanceof BNode)) continue;
                    BNode bnode = (BNode)object;
                    Vertex v = DepthFirstEdgeIterable.this.graph.getVertex((Resource)bnode);
                    Set<Edge> set = v.outEdgeSet();
                    DepthFirstEdgeIterable.this.stack.add(set.iterator());
                    continue;
                }
                DepthFirstEdgeIterable.this.pop();
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

