/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.Graph;
import io.konig.core.UidGenerator;
import io.konig.core.Vertex;
import io.konig.core.impl.KonigLiteral;
import java.util.LinkedList;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;

public class GraphBuilder {
    private Graph graph;
    private ValueFactory valueFactory;
    private LinkedList<Resource> stack = new LinkedList();

    public GraphBuilder(Graph graph) {
        this.graph = graph;
        this.valueFactory = new ValueFactoryImpl();
    }

    public GraphBuilder statement(Resource subject, URI predicate, Value object) {
        this.graph.edge(subject, predicate, object);
        return this;
    }

    public GraphBuilder objectProperty(String subject, String predicate, String object) {
        this.graph.edge((Resource)this.uri(subject), this.uri(predicate), (Value)this.uri(object));
        return this;
    }

    public GraphBuilder literalProperty(String subject, String predicate, String object) {
        this.graph.edge((Resource)this.uri(subject), this.uri(predicate), (Value)this.literal(object));
        return this;
    }

    public GraphBuilder literalProperty(Resource subject, URI predicate, String object) {
        this.graph.edge(subject, predicate, (Value)this.literal(object));
        return this;
    }

    public Literal literal(String value) {
        return this.valueFactory.createLiteral(value);
    }

    public URI uri(String value) {
        return this.valueFactory.createURI(value);
    }

    public GraphBuilder beginSubject() {
        BNodeImpl bnode = new BNodeImpl(UidGenerator.INSTANCE.next());
        return this.beginSubject((Resource)bnode);
    }

    public GraphBuilder beginSubject(Vertex v) {
        return this.beginSubject(v.getId());
    }

    public GraphBuilder beginSubject(String iri) {
        return this.beginSubject((Resource)new URIImpl(iri));
    }

    public GraphBuilder beginBNode(URI predicate) {
        Vertex v = this.graph.vertex();
        this.addProperty(predicate, (Value)v.getId());
        return this.beginSubject(v.getId());
    }

    public GraphBuilder beginSubject(Resource subject) {
        this.stack.add(subject);
        return this;
    }

    public GraphBuilder endSubject() {
        this.stack.removeLast();
        return this;
    }

    public Resource peek() {
        return this.stack.getLast();
    }

    public Resource pop() {
        return this.stack.removeLast();
    }

    public GraphBuilder addProperty(URI predicate, Vertex object) {
        return this.addProperty(predicate, (Value)object.getId());
    }

    public GraphBuilder addProperty(URI predicate, Value object) {
        return this.statement(this.peek(), predicate, object);
    }

    public GraphBuilder addLangString(URI predicate, String value, String language) {
        return this.addProperty(predicate, (Value)new LiteralImpl(value, language));
    }

    public GraphBuilder addTypedLiteral(URI predicate, String value, URI type) {
        return this.addProperty(predicate, (Value)new LiteralImpl(value, type));
    }

    public GraphBuilder addList(URI predicate, Value ... object) {
        Resource subject = this.peek();
        Resource list = this.graph.vertex().getId();
        this.graph.edge(subject, predicate, (Value)list);
        for (int i = 0; i < object.length; ++i) {
            this.graph.edge(list, RDF.FIRST, object[i]);
            if (i == object.length - 1) {
                this.graph.edge(list, RDF.REST, (Value)RDF.NIL);
                continue;
            }
            Resource rest = this.graph.vertex().getId();
            this.graph.edge(list, RDF.REST, (Value)rest);
            list = rest;
        }
        return this;
    }

    public GraphBuilder addProperty(URI predicate, int value) {
        return this.addProperty(predicate, (Value)this.valueFactory.createLiteral(value));
    }

    public GraphBuilder addProperty(URI predicate, boolean truth) {
        return this.addProperty(predicate, (Value)this.valueFactory.createLiteral(truth));
    }

    public GraphBuilder addLiteral(URI predicate, String object) {
        return this.addProperty(predicate, (Value)new KonigLiteral(object));
    }

    public GraphBuilder addFloat(URI predicate, float value) {
        return this.addProperty(predicate, (Value)new LiteralImpl(Float.toString(value), XMLSchema.FLOAT));
    }

    public GraphBuilder addLiteral(URI predicate, String value, URI datatype) {
        return this.addProperty(predicate, (Value)new KonigLiteral(value, datatype));
    }

    public GraphBuilder addDouble(URI predicate, double value) {
        return this.addProperty(predicate, (Value)new LiteralImpl(Double.toString(value), XMLSchema.DOUBLE));
    }

    public GraphBuilder addInt(URI predicate, int value) {
        return this.addProperty(predicate, (Value)new LiteralImpl(Integer.toString(value), XMLSchema.INT));
    }
}

