/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.UidGenerator;
import io.konig.core.impl.KonigLiteral;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class KonigValueFactory
implements ValueFactory {
    private DatatypeFactory datatypeFactory;

    public URI createURI(String uri) {
        return new URIImpl(uri);
    }

    public URI createURI(String namespace, String localName) {
        return new URIImpl(namespace + localName);
    }

    public BNode createBNode() {
        return new BNodeImpl(UidGenerator.INSTANCE.next());
    }

    public BNode createBNode(String nodeID) {
        return new BNodeImpl(nodeID);
    }

    public Literal createLiteral(String label) {
        return new KonigLiteral(label);
    }

    public Literal createLiteral(String label, String language) {
        return new KonigLiteral(label, language);
    }

    public Literal createLiteral(String label, URI datatype) {
        return new KonigLiteral(label, datatype);
    }

    public Literal createLiteral(boolean value) {
        return new KonigLiteral(Boolean.toString(value), XMLSchema.BOOLEAN);
    }

    public Literal createLiteral(byte value) {
        return new KonigLiteral(Byte.toString(value), XMLSchema.BYTE);
    }

    public Literal createLiteral(short value) {
        return new KonigLiteral(Short.toString(value), XMLSchema.SHORT);
    }

    public Literal createLiteral(int value) {
        return new KonigLiteral(Integer.toString(value), XMLSchema.INT);
    }

    public Literal createLiteral(long value) {
        return new KonigLiteral(Long.toString(value), XMLSchema.LONG);
    }

    public Literal createLiteral(float value) {
        return new KonigLiteral(Float.toString(value), XMLSchema.FLOAT);
    }

    public Literal createLiteral(double value) {
        return new KonigLiteral(Double.toString(value), XMLSchema.DOUBLE);
    }

    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return new KonigLiteral(calendar.toXMLFormat(), XMLSchema.DATETIME);
    }

    public Literal createLiteral(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        XMLGregorianCalendar calendar = this.datatypeFactory().newXMLGregorianCalendar(c);
        return this.createLiteral(calendar);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object) {
        return new StatementImpl(subject, predicate, object);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object, Resource context) {
        return new ContextStatementImpl(subject, predicate, object, context);
    }

    private DatatypeFactory datatypeFactory() {
        if (this.datatypeFactory == null) {
            try {
                this.datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.datatypeFactory;
    }
}

