/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

public class NameMap
extends HashMap<String, URI> {
    private static final long serialVersionUID = 1L;
    public static URI AMBIGUOUS = new URIImpl("urn:ambiguous");
    private Map<String, Set<URI>> ambiguous = new HashMap<String, Set<URI>>();

    public NameMap() {
    }

    public NameMap(Graph graph) {
        this.addAll(graph);
    }

    public void addStaticFields(Class<?> type) {
        Field[] declaredFields;
        for (Field field : declaredFields = type.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !URI.class.isAssignableFrom(field.getType())) continue;
            try {
                URI value = (URI)field.get(null);
                this.put(value.getLocalName(), value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new KonigException(e);
            }
        }
    }

    public void addAll(Graph graph) {
        for (Edge edge : graph) {
            Resource subject = edge.getSubject();
            URI predicate = edge.getPredicate();
            Value object = edge.getObject();
            this.add((Value)subject);
            this.add((Value)predicate);
            this.add(object);
        }
    }

    public void addShapes(Collection<Shape> shapeList) {
        for (Shape s : shapeList) {
            this.addProperties(s.getProperty());
        }
    }

    private void addProperties(List<PropertyConstraint> property) {
        if (property != null) {
            for (PropertyConstraint c : property) {
                this.add((Value)c.getPredicate());
            }
        }
    }

    public void add(Value value) {
        if (value instanceof URI) {
            URI uri = (URI)value;
            String localName = uri.getLocalName();
            this.put(localName, uri);
        }
    }

    @Override
    public URI put(String name, URI uri) {
        URI result = super.put(name, uri);
        if (result != null && !result.equals((Object)uri)) {
            if (this.ambiguous == null) {
                this.ambiguous = new HashMap<String, Set<URI>>();
            }
            Set<URI> set = null;
            if (result != AMBIGUOUS) {
                super.put(name, AMBIGUOUS);
                set = new HashSet<URI>();
                this.ambiguous.put(name, set);
            } else {
                result = AMBIGUOUS;
                set = this.ambiguous.get(name);
                set.add(uri);
            }
        }
        return result;
    }

    public Set<URI> getAll(String name) {
        URI unique;
        Set<URI> result = this.ambiguous.get(name);
        if (result == null && (unique = this.get(name)) != null) {
            result = new HashSet<URI>();
            result.add(unique);
        }
        return result == null ? Collections.emptySet() : result;
    }

    public static void appendAll(StringBuilder builder, NamespaceManager nsManager, Set<URI> set) {
        ArrayList<String> list = new ArrayList<String>();
        for (URI uri : set) {
            StringBuilder stringBuilder = new StringBuilder();
            Namespace ns = nsManager.findByName(uri.getNamespace());
            if (ns == null) {
                stringBuilder.append('<');
                stringBuilder.append(uri.stringValue());
                stringBuilder.append('>');
            } else {
                stringBuilder.append(ns.getPrefix());
                stringBuilder.append(':');
                stringBuilder.append(uri.getLocalName());
            }
            list.add(stringBuilder.toString());
        }
        Collections.sort(list);
        String comma = "";
        for (String string : list) {
            builder.append(comma);
            builder.append(string);
            comma = ", ";
        }
    }

    public URI get(String name) {
        URI result = (URI)super.get(name);
        if (result == AMBIGUOUS) {
            result = null;
        }
        return result;
    }
}

