/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.Graph;
import io.konig.core.NamespaceInfo;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class NamespaceInfoManager {
    private Map<String, NamespaceInfo> map = new HashMap<String, NamespaceInfo>();

    public void load(Graph graph) {
        OwlReasoner owl = new OwlReasoner(graph);
        for (Vertex v : graph.vertices()) {
            Resource node = v.getId();
            if (!(node instanceof URI)) continue;
            URI iri = (URI)node;
            String namespace = iri.getNamespace();
            NamespaceInfo set = this.map.get(namespace);
            if (set == null) {
                set = new NamespaceInfo(namespace);
                this.map.put(namespace, set);
            }
            set.getTerms().add(iri);
            if (!owl.isNamedIndividual((Resource)iri)) continue;
            set.getIndividuals().add(iri);
        }
    }

    public Collection<NamespaceInfo> listNamespaces() {
        return this.map.values();
    }

    public NamespaceInfo getNamespaceInfo(String namespace) {
        return this.map.get(namespace);
    }
}

