/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.Context;
import io.konig.core.ContextManager;
import io.konig.core.NamespaceManager;
import io.konig.core.Term;
import java.util.List;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.URIImpl;

public class NamespaceReasoner {
    private NamespaceManager namespaceManager;

    public NamespaceReasoner(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public void gatherAllNamespaces(ContextManager contextManager) {
        List<String> list = contextManager.listContexts();
        for (String contextId : list) {
            Context context = contextManager.getContextByURI(contextId);
            this.gatherNamespaces(context);
        }
    }

    public void gatherNamespaces(Context context) {
        context.compile();
        Context inverse = context.inverse();
        List<Term> termList = context.asList();
        for (Term term : termList) {
            Term namespaceTerm;
            String expandedId = term.getExpandedIdValue();
            URIImpl uri = new URIImpl(expandedId);
            String namespaceName = uri.getNamespace();
            Namespace ns = this.namespaceManager.findByName(namespaceName);
            if (ns != null || (namespaceTerm = inverse.getTerm(namespaceName)) == null) continue;
            String prefix = namespaceTerm.getKey();
            this.namespaceManager.add(prefix, namespaceName);
        }
    }
}

