/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.AmbiguousPreferredClassException;
import io.konig.core.DatatypeRestriction;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.OwlVocab;
import io.konig.core.vocab.Schema;
import io.konig.core.vocab.XSD;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.GEO;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;

public class OwlReasoner {
    private Graph graph;
    private Map<String, EquivalenceClass> equivalentClassMap;
    private Map<String, DatatypeRestriction> datatypeMap;
    private boolean inferredClassesFromSubclass;

    public OwlReasoner(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Resource getRange(URI predicate) {
        Vertex v = this.graph.getVertex((Resource)predicate);
        return v == null ? null : v.getResource(RDFS.RANGE);
    }

    public Resource getDomain(URI predicate) {
        Vertex v = this.graph.getVertex((Resource)predicate);
        return v == null ? null : v.getResource(RDFS.DOMAIN);
    }

    public String friendlyName(Resource subject) {
        Vertex v;
        if (subject != null && (v = this.graph.getVertex(subject)) != null) {
            return this.friendlyName(v);
        }
        return null;
    }

    public Set<Vertex> allNamedIndividuals() {
        HashSet<Vertex> set = new HashSet<Vertex>();
        this.addSubclasses(set, Schema.Enumeration);
        this.addSubclasses(set, OwlVocab.NamedIndividual);
        HashSet<Vertex> result = new HashSet<Vertex>();
        for (Vertex v : set) {
            Resource id = v.getId();
            if (!(id instanceof URI)) continue;
            this.addAllInstances(result, (URI)id);
        }
        return result;
    }

    private void addSubclasses(Set<Vertex> set, URI classId) {
        Vertex v = this.graph.getVertex((Resource)classId);
        if (v != null) {
            set.add(v);
            set.addAll(this.subClassVertices(classId));
        }
    }

    public Set<URI> allClassIds() {
        HashSet<URI> set = new HashSet<URI>();
        for (Vertex v : this.owlClassList()) {
            if (!(v.getId() instanceof URI)) continue;
            set.add((URI)v.getId());
        }
        return set;
    }

    public Set<URI> allRdfOwlAndShaclProperties(ShapeManager shapeManager) {
        Set<Vertex> rdfOwl = this.allRdfAndOwlProperties();
        HashSet<URI> result = new HashSet<URI>();
        for (Vertex v : rdfOwl) {
            if (!(v.getId() instanceof URI)) continue;
            result.add((URI)v.getId());
        }
        if (shapeManager != null) {
            for (Shape shape : shapeManager.listShapes()) {
                for (PropertyConstraint p : shape.getProperty()) {
                    URI predicate = p.getPredicate();
                    if (predicate == null) continue;
                    result.add(predicate);
                }
            }
        }
        return result;
    }

    public Set<Vertex> allRdfAndOwlProperties() {
        HashSet<Vertex> set = new HashSet<Vertex>();
        this.addAllInstances(set, RDF.PROPERTY);
        this.addAllInstances(set, OWL.FUNCTIONALPROPERTY);
        this.addAllInstances(set, OWL.DATATYPEPROPERTY);
        this.addAllInstances(set, OWL.OBJECTPROPERTY);
        this.addAllInstances(set, OWL.ANNOTATIONPROPERTY);
        this.addAllInstances(set, OWL.DEPRECATEDPROPERTY);
        this.addAllInstances(set, OWL.EQUIVALENTPROPERTY);
        this.addAllInstances(set, OWL.INVERSEFUNCTIONALPROPERTY);
        this.addAllInstances(set, OWL.ONTOLOGYPROPERTY);
        this.addAllInstances(set, OWL.SYMMETRICPROPERTY);
        this.addAllInstances(set, OWL.TRANSITIVEPROPERTY);
        return set;
    }

    private void addAllInstances(Set<Vertex> set, URI entityType) {
        Vertex v = this.graph.getVertex((Resource)entityType);
        if (v != null) {
            set.addAll(v.asTraversal().in(RDF.TYPE).toVertexList());
        }
    }

    public String friendlyName(Vertex subject) {
        String name = this.stringValue(subject, Schema.name, RDFS.LABEL);
        if (name == null) {
            name = subject.getId() instanceof URI ? ((URI)subject.getId()).getLocalName() : subject.getId().stringValue();
        }
        return name;
    }

    public String stringValue(Vertex subject, URI ... predicate) {
        for (URI p : predicate) {
            Value value = subject.getValue(p);
            if (value == null) continue;
            return value.stringValue();
        }
        return null;
    }

    public List<Vertex> owlClassList() {
        return this.graph.v((Resource)OWL.CLASS).in(RDF.TYPE).toVertexList();
    }

    public List<Vertex> ontologyList() {
        return this.graph.v((Resource)OWL.ONTOLOGY).in(RDF.TYPE).toVertexList();
    }

    public List<Vertex> subClasses(Vertex v) {
        return v.asTraversal().in(RDFS.SUBCLASSOF).toVertexList();
    }

    public List<Vertex> subClassVertices(URI classId) {
        return this.graph.v((Resource)classId).in(RDFS.SUBCLASSOF).toVertexList();
    }

    public Set<URI> subClasses(URI classId) {
        return this.graph.v((Resource)classId).in(RDFS.SUBCLASSOF).toUriSet();
    }

    public Set<Vertex> allSubClasses(Vertex v) {
        HashSet<Vertex> set = new HashSet<Vertex>();
        this.addSubClasses(set, this.subClasses(v));
        return set;
    }

    private void addSubClasses(Set<Vertex> set, List<Vertex> subClasses) {
        for (Vertex v : subClasses) {
            if (set.contains(v)) continue;
            set.add(v);
            this.addSubClasses(set, this.subClasses(v));
        }
    }

    public Set<URI> namedSubClasses(Resource typeId) {
        Vertex v = this.graph.getVertex(typeId);
        if (v == null) {
            return new HashSet<URI>();
        }
        return v.asTraversal().in(RDFS.SUBCLASSOF).toUriSet();
    }

    public Set<URI> allNamedSubClasses(Resource typeId) {
        Vertex v = this.graph.getVertex(typeId);
        if (v == null) {
            return new HashSet<URI>();
        }
        HashSet<URI> result = new HashSet<URI>();
        Set<Vertex> vertices = this.allSubClasses(v);
        for (Vertex u : vertices) {
            if (!(u.getId() instanceof URI)) continue;
            result.add((URI)u.getId());
        }
        return result;
    }

    private void buildEquivalentClasses() {
        if (this.equivalentClassMap == null) {
            this.inferClassFromSubclassOf();
            List<Vertex> list = this.graph.v((Resource)OWL.CLASS).union(new Value[]{RDFS.CLASS}).union(new Value[]{RDFS.DATATYPE}).union(new Value[]{Schema.DataType}).union(new Value[]{RDFS.LITERAL}).distinct().in(RDF.TYPE).distinct().toVertexList();
            this.equivalentClassMap = new HashMap<String, EquivalenceClass>();
            this.assembleEquivalenceClasses(list, this.equivalentClassMap);
        }
    }

    public Set<URI> rangeIncludes(URI property) {
        Set<URI> result = this.graph.v((Resource)property).out(RDFS.RANGE).toUriSet();
        Set<URI> rest = this.graph.v((Resource)property).out(Schema.rangeIncludes).toUriSet();
        result.addAll(rest);
        return result;
    }

    public void inferRdfPropertiesFromPropertyConstraints(ShapeManager shapeManager, Graph sink) {
        if (shapeManager == null) {
            return;
        }
        if (sink == null) {
            sink = this.graph;
        }
        for (Shape shape : shapeManager.listShapes()) {
            URI targetClass = shape.getTargetClass();
            for (PropertyConstraint p : shape.getProperty()) {
                URI type;
                URI datatype;
                URI predicate = p.getPredicate();
                if (predicate == null) continue;
                Vertex property = this.graph.getVertex((Resource)predicate);
                URI propertyType = null;
                URI range = null;
                URI domain = null;
                if (property != null) {
                    propertyType = property.getURI(RDF.TYPE);
                    range = property.getURI(RDFS.RANGE);
                    domain = property.getURI(RDFS.RANGE);
                    if (domain != null) {
                        targetClass = null;
                    }
                }
                if ((datatype = p.getDatatype()) != null) {
                    URI type2 = propertyType == null ? OWL.DATATYPEPROPERTY : null;
                    this.edge(sink, (Resource)predicate, RDF.TYPE, (Value)type2);
                    this.edge(sink, (Resource)predicate, Schema.domainIncludes, (Value)targetClass);
                    this.edge(sink, (Resource)predicate, Schema.rangeIncludes, (Value)datatype);
                    continue;
                }
                URI valueClass = range == null ? this.asIRI(p.getValueClass()) : null;
                Object object = type = propertyType == null ? OWL.OBJECTPROPERTY : null;
                if (valueClass != null) {
                    this.edge(sink, (Resource)predicate, RDF.TYPE, (Value)type);
                    this.edge(sink, (Resource)predicate, Schema.domainIncludes, (Value)targetClass);
                    this.edge(sink, (Resource)predicate, Schema.rangeIncludes, (Value)valueClass);
                    continue;
                }
                Shape valueShape = p.getShape();
                if (valueShape != null) {
                    valueClass = valueShape.getTargetClass();
                    if (valueClass != null) {
                        this.edge(sink, (Resource)predicate, RDF.TYPE, (Value)type);
                        this.edge(sink, (Resource)predicate, Schema.domainIncludes, (Value)targetClass);
                        this.edge(sink, (Resource)predicate, Schema.rangeIncludes, (Value)valueClass);
                        continue;
                    }
                    this.edge(sink, (Resource)predicate, RDF.TYPE, (Value)type);
                    this.edge(sink, (Resource)predicate, Schema.domainIncludes, (Value)targetClass);
                    continue;
                }
                this.edge(sink, (Resource)predicate, RDF.TYPE, (Value)type);
                this.edge(sink, (Resource)predicate, Schema.domainIncludes, (Value)targetClass);
            }
        }
    }

    private URI asIRI(Resource resource) {
        return resource instanceof URI ? (URI)resource : null;
    }

    private void edge(Graph sink, Resource subject, URI predicate, Value object) {
        if (sink != null && subject != null && predicate != null && object != null) {
            sink.edge(subject, predicate, object);
        }
    }

    private void assembleEquivalenceClasses(List<Vertex> list, Map<String, EquivalenceClass> map) {
        for (Vertex owlClass : list) {
            this.analyzeEquivalentClasses(owlClass, map);
        }
    }

    private void analyzeEquivalentClasses(Vertex owlClass, Map<String, EquivalenceClass> map) {
        String key = owlClass.getId().stringValue();
        EquivalenceClass e = map.get(key);
        if (e == null) {
            e = new EquivalenceClass();
            map.put(key, e);
            this.addMembers(e, owlClass, map);
        }
    }

    private void addMembers(EquivalenceClass e, Vertex owlClass, Map<String, EquivalenceClass> map) {
        Set<Vertex> set = e.getMembers();
        set.add(owlClass);
        List<Vertex> list = owlClass.asTraversal().out(OWL.EQUIVALENTCLASS).distinct().toVertexList();
        for (Vertex v : list) {
            String otherKey = v.getId().stringValue();
            EquivalenceClass other = map.get(otherKey);
            if (other == null) {
                map.put(otherKey, e);
                set.add(v);
                this.addMembers(e, v, map);
                continue;
            }
            if (other == e) continue;
            map.put(otherKey, e);
            e.addAll(other);
        }
    }

    public Vertex preferredClass(Vertex owlClass) throws AmbiguousPreferredClassException {
        Vertex result;
        this.buildEquivalentClasses();
        EquivalenceClass e = this.equivalentClassMap.get(owlClass.getId().stringValue());
        if (e != null && (result = e.getPreferredEntity(Konig.PreferredClass)) != null) {
            owlClass = result;
        }
        return owlClass;
    }

    public boolean isSubclassOfLiteral(Resource id) {
        return this.isDatatype(id) || this.isSubClassOf(id, (Resource)RDFS.LITERAL);
    }

    public boolean isDatatype(Resource id) {
        URI uri;
        if (id instanceof URI && ("http://www.w3.org/2001/XMLSchema#".equals((uri = (URI)id).getNamespace()) || GEO.WKT_LITERAL.equals((Object)id) || RDF.LANGSTRING.equals((Object)id))) {
            return true;
        }
        Vertex v = this.graph.getVertex(id);
        if (v != null) {
            boolean truth;
            boolean bl = truth = !v.asTraversal().hasValue(RDF.TYPE, (Value)RDFS.DATATYPE).toVertexList().isEmpty();
            if (truth) {
                return true;
            }
        }
        return false;
    }

    public Resource leastCommonSuperDatatype(Resource aType, Resource bType) {
        Vertex a = this.graph.vertex(aType);
        Vertex b = this.graph.vertex(bType);
        if (RdfUtil.isSubClassOf(a, bType)) {
            return bType;
        }
        if (RdfUtil.isSubClassOf(b, aType)) {
            return aType;
        }
        Set<String> set = this.superClasses(a);
        List<Vertex> stack = b.asTraversal().out(RDFS.SUBCLASSOF).toVertexList();
        for (int i = 0; i < stack.size(); ++i) {
            Vertex w = stack.get(i);
            Resource id = w.getId();
            String key = id.stringValue();
            if (!set.contains(key)) continue;
            return (URI)id;
        }
        return RDFS.DATATYPE;
    }

    public URI leastCommonSuperClass(Collection<URI> classes) {
        URI result = null;
        for (URI owlClass : classes) {
            if (result == null) {
                result = owlClass;
                continue;
            }
            if (!(result = (URI)this.leastCommonSuperClass((Resource)result, (Resource)owlClass)).equals((Object)OWL.THING)) continue;
            return OWL.THING;
        }
        return result;
    }

    public Resource leastCommonSuperClass(Resource aClass, Resource bClass) {
        if (aClass == null) {
            return bClass;
        }
        if (bClass == null) {
            return aClass;
        }
        if (aClass.equals(bClass)) {
            return aClass;
        }
        Vertex a = this.graph.vertex(aClass);
        Vertex b = this.graph.vertex(bClass);
        if (RdfUtil.isSubClassOf(a, bClass)) {
            return bClass;
        }
        if (RdfUtil.isSubClassOf(b, aClass)) {
            return aClass;
        }
        Set<String> set = this.superClasses(a);
        List<Vertex> stack = b.asTraversal().out(RDFS.SUBCLASSOF).toVertexList();
        for (int i = 0; i < stack.size(); ++i) {
            Vertex w = stack.get(i);
            Resource id = w.getId();
            String key = id.stringValue();
            if (!set.contains(key)) continue;
            return (URI)id;
        }
        return OWL.THING;
    }

    private Set<String> superClasses(Vertex a) {
        HashSet<String> set = new HashSet<String>();
        ArrayList<Vertex> stack = new ArrayList<Vertex>();
        stack.addAll(this.equivalentClasses(a.getId()));
        for (int i = 0; i < stack.size(); ++i) {
            Vertex w = (Vertex)stack.get(i);
            List<Vertex> next = w.asTraversal().out(RDFS.SUBCLASSOF).toVertexList();
            for (Vertex v : next) {
                Set<Vertex> eq = this.equivalentClasses(v.getId());
                for (Vertex u : eq) {
                    if (stack.contains(u)) continue;
                    stack.add(u);
                    if (!(u.getId() instanceof URI)) continue;
                    set.add(u.getId().stringValue());
                }
            }
        }
        return set;
    }

    public boolean isSubClassOf(Resource a, Resource b) {
        if (a == null) {
            throw new IllegalArgumentException("Resource must not be null");
        }
        if (a.equals(b)) {
            return true;
        }
        Vertex va = this.graph.getVertex(a);
        if (va == null) {
            return false;
        }
        return RdfUtil.isSubClassOf(va, b);
    }

    public Set<Vertex> equivalentClasses(Resource owlClass) {
        this.buildEquivalentClasses();
        EquivalenceClass e = this.equivalentClassMap.get(owlClass.stringValue());
        if (e == null) {
            Vertex v = this.graph.vertex(owlClass);
            HashSet<Vertex> result = new HashSet<Vertex>();
            result.add(v);
            return result;
        }
        return e.getMembers();
    }

    public Vertex preferredClass(Resource owlClass) throws AmbiguousPreferredClassException {
        return this.preferredClass(this.graph.vertex(owlClass));
    }

    public URI preferredClassAsURI(URI owlClass) throws AmbiguousPreferredClassException {
        return (URI)this.preferredClass(this.graph.vertex((Resource)owlClass)).getId();
    }

    public void inferTypeOfSuperClass(Vertex thing) {
        Set<URI> typeSet = thing.asTraversal().out(RDF.TYPE).toUriSet();
        HashSet<URI> superSet = new HashSet<URI>();
        for (URI uri : typeSet) {
            this.getTransitiveClosure((Resource)uri, RDFS.SUBCLASSOF, superSet);
        }
        for (URI superClass : superSet) {
            this.graph.edge(thing.getId(), RDF.TYPE, (Value)superClass);
        }
    }

    public void getTransitiveClosure(Resource source, URI predicate, Set<URI> sink) {
        Vertex v = this.graph.getVertex(source);
        if (v != null) {
            Set<Edge> out = v.outProperty(predicate);
            for (Edge e : out) {
                URI uri;
                Value object = e.getObject();
                if (!(object instanceof URI) || sink.contains(uri = (URI)object)) continue;
                sink.add(uri);
                this.getTransitiveClosure((Resource)uri, predicate, sink);
            }
        }
    }

    public URI mostSpecificType(Iterable<URI> collection, URI filter) {
        URI best = null;
        for (URI candidate : collection) {
            if (filter != null && !candidate.equals((Object)filter) && !this.isSubClassOf((Resource)candidate, (Resource)filter)) continue;
            if (best == null) {
                best = candidate;
                continue;
            }
            if (!this.isSubClassOf((Resource)candidate, (Resource)best)) continue;
            best = candidate;
        }
        return best;
    }

    public void inferClassesFromShapes(ShapeManager shapeManager, Graph sink) {
        for (Shape shape : shapeManager.listShapes()) {
            URI targetClass = shape.getTargetClass();
            if (targetClass != null) {
                sink.edge((Resource)targetClass, RDF.TYPE, (Value)OWL.CLASS);
            }
            for (PropertyConstraint p : shape.getProperty()) {
                Resource owlClass = p.getValueClass();
                if (owlClass == null) continue;
                sink.edge(owlClass, RDF.TYPE, (Value)OWL.CLASS);
            }
        }
    }

    public void inferClassFromSubclassOf() {
        if (!this.inferredClassesFromSubclass) {
            this.inferredClassesFromSubclass = true;
            ArrayList<Edge> list = new ArrayList<Edge>(this.graph);
            for (Edge e : list) {
                URI predicate = e.getPredicate();
                if (!predicate.equals((Object)RDFS.SUBCLASSOF)) continue;
                this.graph.edge(e.getSubject(), RDF.TYPE, (Value)OWL.CLASS);
                this.graph.edge((Resource)e.getObject(), RDF.TYPE, (Value)OWL.CLASS);
            }
        }
    }

    public boolean instanceOf(Resource subject, URI owlClass) {
        Vertex v = this.graph.getVertex(subject);
        if (v != null) {
            Set<URI> typeSet = v.asTraversal().out(RDF.TYPE).toUriSet();
            for (URI type : typeSet) {
                if (!type.equals((Object)owlClass)) continue;
                return true;
            }
            HashSet<URI> superTypeSet = new HashSet<URI>();
            for (URI type : typeSet) {
                this.getTransitiveClosure((Resource)type, RDFS.SUBCLASSOF, superTypeSet);
            }
            for (URI superType : superTypeSet) {
                if (!superType.equals((Object)owlClass)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRealNumber(URI owlClass) {
        return XMLSchema.DECIMAL.equals((Object)owlClass) || XMLSchema.DOUBLE.equals((Object)owlClass) || XMLSchema.FLOAT.equals((Object)owlClass) || Schema.Float.equals((Object)owlClass) || Schema.Number.equals((Object)owlClass);
    }

    public boolean isBooleanType(URI owlClass) {
        return XMLSchema.BOOLEAN.equals((Object)owlClass) || Schema.Boolean.equals((Object)owlClass);
    }

    public boolean isPlainLiteral(URI owlClass) {
        return XMLSchema.STRING.equals((Object)owlClass) || Schema.Text.equals((Object)owlClass);
    }

    public Set<URI> inverseOf(URI property) {
        HashSet<URI> result = new HashSet<URI>();
        Set<URI> outward = this.graph.v((Resource)property).out(OWL.INVERSEOF).toUriSet();
        result.addAll(outward);
        Set<URI> inward = this.graph.v((Resource)property).in(OWL.INVERSEOF).toUriSet();
        result.addAll(inward);
        return result;
    }

    public boolean isInverseFunctionalProperty(URI property) {
        return this.instanceOf((Resource)property, OWL.INVERSEFUNCTIONALPROPERTY);
    }

    public boolean isNumericDatatype(URI owlClass) {
        return this.isIntegerDatatype(owlClass) || this.isRealNumber(owlClass);
    }

    public boolean isIntegerDatatype(URI owlClass) {
        return XMLSchema.BYTE.equals((Object)owlClass) || XMLSchema.INT.equals((Object)owlClass) || XMLSchema.INTEGER.equals((Object)owlClass) || XMLSchema.LONG.equals((Object)owlClass) || XMLSchema.NEGATIVE_INTEGER.equals((Object)owlClass) || XMLSchema.NON_NEGATIVE_INTEGER.equals((Object)owlClass) || XMLSchema.NON_POSITIVE_INTEGER.equals((Object)owlClass) || XMLSchema.SHORT.equals((Object)owlClass) || XMLSchema.UNSIGNED_BYTE.equals((Object)owlClass) || XMLSchema.UNSIGNED_INT.equals((Object)owlClass) || XMLSchema.UNSIGNED_LONG.equals((Object)owlClass) || XMLSchema.UNSIGNED_SHORT.equals((Object)owlClass) || Schema.Integer.equals((Object)owlClass);
    }

    public boolean isEnumerationClass(Resource owlClass) {
        return this.isSubClassOf(owlClass, (Resource)Schema.Enumeration);
    }

    public boolean isTypeOf(Resource individual, Resource owlClass) {
        Vertex v = this.graph.getVertex(individual);
        if (v != null) {
            List<Vertex> typeList = v.asTraversal().out(RDF.TYPE).toVertexList();
            for (Vertex type : typeList) {
                if (!type.getId().equals(owlClass)) continue;
                return true;
            }
            for (Vertex type : typeList) {
                Resource typeId = type.getId();
                if (!this.isSubClassOf(typeId, owlClass)) continue;
                return true;
            }
        }
        return false;
    }

    public DatatypeRestriction datatypeRestriction(URI datatype) {
        this.getDatatypeMap();
        DatatypeRestriction result = this.datatypeMap.get(datatype.stringValue());
        if (result == null) {
            result = this.createDatatypeRestriction(datatype);
            this.datatypeMap.put(datatype.stringValue(), result);
        }
        return result;
    }

    private DatatypeRestriction createDatatypeRestriction(URI datatype) {
        Vertex v = this.graph.vertex((Resource)datatype);
        DatatypeRestriction r = new DatatypeRestriction();
        r.setOnDatatype(this.asURI(v.getValue(OwlVocab.onDatatype)));
        Vertex withRestrictions = v.vertexValue(OwlVocab.withRestrictions);
        if (withRestrictions != null) {
            List<Value> list = withRestrictions.asList();
            for (Value value : list) {
                if (!(value instanceof Resource)) continue;
                Vertex w = this.graph.vertex((Resource)value);
                Double maxExclusive = w.doubleValue(XSD.maxExclusive);
                Double maxInclusive = w.doubleValue(XSD.maxInclusive);
                Integer maxLength = w.integerValue(XSD.maxLength);
                Double minExclusive = w.doubleValue(XSD.minExclusive);
                Double minInclusive = w.doubleValue(XSD.minInclusive);
                String pattern = w.stringValue(XSD.pattern);
                if (maxExclusive != null) {
                    r.setMaxExclusive(maxExclusive);
                }
                if (maxInclusive != null) {
                    r.setMaxInclusive(maxInclusive);
                }
                if (maxLength != null) {
                    r.setMaxLength(maxLength);
                }
                if (minExclusive != null) {
                    r.setMinExclusive(minExclusive);
                }
                if (minInclusive != null) {
                    r.setMinInclusive(minInclusive);
                }
                if (pattern == null) continue;
                r.setPattern(pattern);
            }
        }
        return r;
    }

    private URI asURI(Value value) {
        return value instanceof URI ? (URI)value : null;
    }

    private Map<String, DatatypeRestriction> getDatatypeMap() {
        if (this.datatypeMap == null) {
            this.datatypeMap = new HashMap<String, DatatypeRestriction>();
        }
        return this.datatypeMap;
    }

    public Set<URI> superClasses(URI targetClass) {
        Vertex v = this.graph.getVertex((Resource)targetClass);
        if (v == null) {
            return Collections.emptySet();
        }
        return v.asTraversal().out(RDFS.SUBCLASSOF).toUriSet();
    }

    public Set<URI> disjointTypes(Collection<URI> types) {
        HashSet<URI> result = new HashSet<URI>();
        block0: for (URI a : types) {
            Iterator sequence = result.iterator();
            while (sequence.hasNext()) {
                URI b = (URI)sequence.next();
                if (this.isSubClassOf((Resource)a, (Resource)b)) {
                    sequence.remove();
                    break;
                }
                if (!this.isSubClassOf((Resource)b, (Resource)a)) continue;
                continue block0;
            }
            result.add(a);
        }
        return result;
    }

    public Set<URI> specificTypes(Resource individual) {
        Set<URI> result = null;
        Vertex v = this.graph.getVertex(individual);
        if (v != null) {
            Set<Edge> edges = v.outProperty(RDF.TYPE);
            HashSet<URI> typeSet = new HashSet<URI>();
            for (Edge e : edges) {
                Value value = e.getObject();
                if (!(value instanceof URI)) continue;
                typeSet.add((URI)value);
            }
            result = this.disjointTypes(typeSet);
        } else {
            result = new HashSet<URI>();
        }
        return result;
    }

    public boolean isEnumerationMember(Resource id) {
        return this.isTypeOf(id, (Resource)Schema.Enumeration);
    }

    public boolean isNamedIndividual(Resource subject) {
        return this.isTypeOf(subject, (Resource)Schema.Enumeration) || this.isTypeOf(subject, (Resource)OwlVocab.NamedIndividual);
    }

    public boolean isProperty(URI target) {
        return this.isTypeOf((Resource)target, (Resource)RDF.PROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.FUNCTIONALPROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.DATATYPEPROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.OBJECTPROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.ANNOTATIONPROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.DEPRECATEDPROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.EQUIVALENTPROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.INVERSEFUNCTIONALPROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.ONTOLOGYPROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.SYMMETRICPROPERTY) || this.isTypeOf((Resource)target, (Resource)OWL.TRANSITIVEPROPERTY);
    }

    public URI mostSpecificTypeOf(Vertex v) {
        Set<URI> typeSet = v.asTraversal().out(RDF.TYPE).toUriSet();
        return this.mostSpecificType(typeSet, null);
    }

    private static class EquivalenceClass {
        private Set<Vertex> members = new HashSet<Vertex>();
        private Vertex preferredEntity;
        private boolean computedPreferredEntity;

        private EquivalenceClass() {
        }

        public Vertex getPreferredEntity(URI preferredType) throws AmbiguousPreferredClassException {
            if (!this.computedPreferredEntity) {
                this.computedPreferredEntity = true;
                for (Vertex v : this.members) {
                    if (!v.hasProperty(RDF.TYPE, (Value)preferredType)) continue;
                    if (this.preferredEntity == null) {
                        this.preferredEntity = v;
                        continue;
                    }
                    throw new AmbiguousPreferredClassException(this.members);
                }
            }
            return this.preferredEntity;
        }

        public Set<Vertex> getMembers() {
            return this.members;
        }

        public void addAll(EquivalenceClass other) {
            this.members.addAll(other.getMembers());
        }
    }
}

