/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.NameMap;
import io.konig.core.NamespaceManager;
import io.konig.core.Path;
import io.konig.core.path.PathParseException;
import io.konig.core.path.PathParser;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFactory {
    private static final Logger logger = LoggerFactory.getLogger(PathFactory.class);
    public static boolean RETURN_NULL_ON_FAILURE = false;
    private NamespaceManager nsManager;
    private NameMap nameMap;

    public PathFactory() {
    }

    public PathFactory(NamespaceManager nsManager) {
        this.nsManager = nsManager;
    }

    public PathFactory(NamespaceManager nsManager, NameMap nameMap) {
        this.nsManager = nsManager;
        this.nameMap = nameMap;
    }

    public NamespaceManager getNamespaceManager() {
        return this.nsManager;
    }

    public Path createPath(String text) throws PathParseException {
        try {
            StringReader reader = new StringReader(text);
            PathParser parser = new PathParser(this.nsManager);
            parser.setNameMap(this.nameMap);
            return parser.path(reader);
        }
        catch (PathParseException e) {
            if (RETURN_NULL_ON_FAILURE) {
                logger.warn("Failed to parse path: {}", (Object)text);
                return null;
            }
            throw e;
        }
    }
}

