/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class SPARQLBuilder {
    private StringBuilder builder;
    private NamespaceManager nsManager;
    private OwlReasoner owlReasoner;

    public SPARQLBuilder(NamespaceManager nsManager, OwlReasoner owlReasoner) {
        this.nsManager = nsManager;
        this.owlReasoner = owlReasoner;
        this.builder = new StringBuilder();
    }

    public void append(char c) {
        this.builder.append(c);
    }

    public void append(String s) {
        this.builder.append(s);
    }

    public void append(URI uri) {
        Namespace ns = this.nsManager.findByName(uri.getNamespace());
        if (ns == null) {
            this.builder.append(uri.stringValue());
        } else {
            this.builder.append(ns.getPrefix());
            this.builder.append(':');
            this.builder.append(uri.getLocalName());
        }
    }

    public void append(Value value) {
        if (value instanceof URI) {
            this.append((URI)value);
        } else if (value instanceof Literal) {
            Literal literal = (Literal)value;
            String text = value.toString();
            String language = literal.getLanguage();
            if (language != null) {
                this.builder.append('\"');
                this.builder.append(text);
                this.builder.append('\"');
                this.builder.append('@');
                this.builder.append(language);
            } else {
                URI datatype = literal.getDatatype();
                if (datatype == null || this.owlReasoner.isPlainLiteral(datatype)) {
                    this.builder.append('\"');
                    this.builder.append(text);
                    this.builder.append('\"');
                } else if (this.owlReasoner.isIntegerDatatype(datatype)) {
                    long integer = Long.parseLong(text);
                    this.builder.append(integer);
                } else if (this.owlReasoner.isRealNumber(datatype)) {
                    double number = Double.parseDouble(text);
                    this.builder.append(number);
                } else if (this.owlReasoner.isBooleanType(datatype)) {
                    boolean truth = "true".equalsIgnoreCase(text);
                    this.builder.append(truth);
                } else {
                    this.builder.append('\"');
                    this.builder.append(text);
                    this.builder.append('\"');
                    this.builder.append('^');
                    this.builder.append(datatype);
                }
            }
        } else {
            throw new KonigException("Blank Nodes not supported");
        }
    }

    public String toString() {
        return this.builder.toString();
    }
}

