/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core;

import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.io.PrettyPrintWriter;
import java.io.IOException;
import org.openrdf.model.URI;

public class Term
implements Comparable<Term> {
    private String key;
    private String id;
    private String language;
    private String type;
    private String container;
    private URI expandedType;
    private URI expandedId;
    private int index = -1;
    private Kind kind = Kind.ANY;

    public Term(String key, String id) {
        this.key = key;
        this.id = id;
    }

    public Term(String key, String id, Kind kind) {
        this.key = key;
        this.id = id;
        this.kind = kind;
    }

    public Term(String key, String id, String language, String type) {
        this.key = key;
        this.id = id;
        this.language = language;
        this.type = type;
    }

    public Term(String key, String id, String language, String type, String container) {
        this.key = key;
        this.id = id;
        this.language = language;
        this.type = type;
        this.container = container;
    }

    public String getKey() {
        return this.key;
    }

    public String getId() {
        return this.id;
    }

    public Kind getKind() {
        return this.kind == null ? Kind.ANY : this.kind;
    }

    public String getContainer() {
        return this.container;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getType() {
        return this.type;
    }

    public URI getExpandedType() {
        return this.expandedType;
    }

    public void setExpandedType(URI expandedType) {
        this.expandedType = expandedType;
    }

    public URI getExpandedId() {
        return this.expandedId;
    }

    public void setExpandedId(URI expandedId) {
        this.expandedId = expandedId;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.key);
        buffer.append('[');
        String comma = "";
        if (this.id != null) {
            buffer.append("@id: ");
            buffer.append(this.id);
            comma = ", ";
        }
        if (this.type != null) {
            buffer.append(comma);
            buffer.append("@type: ");
            buffer.append(this.type);
            comma = ", ";
        }
        if (this.language != null) {
            buffer.append("@language: ");
            buffer.append(this.language);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String getExpandedIdValue() {
        return this.expandedId != null ? this.expandedId.stringValue() : (this.id != null ? this.id : null);
    }

    @Override
    public int compareTo(Term other) {
        int delta;
        Kind thisKind;
        Kind otherKind = other.kind;
        if (otherKind == null) {
            otherKind = Kind.ANY;
        }
        if ((thisKind = this.kind) == null) {
            thisKind = Kind.ANY;
        }
        if ((delta = thisKind.ordinal() - otherKind.ordinal()) == 0) {
            delta = this.key.compareTo(other.key);
        }
        return delta;
    }

    public void toJson(JsonGenerator json) throws IOException {
        if (this.id != null && this.type == null && this.language == null && this.container == null) {
            json.writeString(this.id);
        } else {
            json.writeStartObject();
            json.writeStringField("@id", this.id);
            if (this.type != null) {
                json.writeStringField("@type", this.type);
            }
            if (this.language != null) {
                json.writeStringField("@languge", this.language);
            }
            if (this.container != null) {
                json.writeStringField("@container", this.container);
            }
            json.writeEndObject();
        }
    }

    public void print(PrettyPrintWriter out) {
        out.indent();
        out.print('\"');
        out.print(this.key);
        out.print("\" : ");
        if (this.container == null && this.language == null && this.type == null) {
            out.print('\"');
            out.print(this.id);
            out.print('\"');
        } else {
            out.println('{');
            out.pushIndent();
            out.indent();
            out.print("\"@id\" : \"");
            out.print(this.id);
            out.print('\"');
            if (this.type != null) {
                out.println(',');
                out.indent();
                out.print("\"@type\" : \"");
                out.print(this.type);
                out.print('\"');
            }
            if (this.container != null) {
                out.println(',');
                out.indent();
                out.print("\"@container\" : \"");
                out.print(this.container);
                out.print('\"');
            }
            if (this.language != null) {
                out.println(',');
                out.indent();
                out.print("\"@language\" : \"");
                out.print(this.language);
                out.print('\"');
            }
            out.println();
            out.popIndent();
            out.indent();
            out.print('}');
        }
    }

    public static enum Kind {
        NAMESPACE,
        CLASS,
        PROPERTY,
        INDIVIDUAL,
        ANY;

    }
}

