/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.binary;

import io.konig.core.Graph;
import io.konig.core.binary.BinaryUtil;
import io.konig.core.binary.Language;
import io.konig.core.binary.Term;
import io.konig.core.binary.TermPart;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;

public class BinaryGraphWriter {
    private static int MAX_BYTE = 256;
    private static int MAX_SHORT = 256;

    public void write(Graph graph, DataOutputStream out) throws IOException {
        Worker worker = new Worker(out);
        worker.write(graph);
    }

    static class Worker {
        private int termSize;
        private int languageSize;
        private Language defaultLanguage;
        private Term root;
        private Map<String, Language> languageMap;
        private Map<String, Integer> bnodeMap;
        private DataOutputStream out;
        private int iriCount;

        public Worker(DataOutputStream out) {
            this.out = out;
            this.root = new Term(null);
            this.languageMap = new HashMap<String, Language>();
            this.bnodeMap = new HashMap<String, Integer>();
        }

        public void write(Graph graph) throws IOException {
            this.buildDictionary(graph);
            this.writeHeader();
            this.writeTerm(this.root);
            this.writeLanguageList();
            this.writeTriples(graph);
        }

        private void writeTriples(Graph graph) throws IOException {
            for (Statement s : graph) {
                this.writeTriple(s);
            }
        }

        private void writeTriple(Statement s) throws IOException {
            this.writeIndividual(s.getSubject());
            Term predicateTerm = this.find(s.getPredicate().stringValue());
            this.writeInteger(this.termSize, predicateTerm.getIndex());
            Value object = s.getObject();
            if (predicateTerm.hasType(128) && predicateTerm.hasType(124)) {
                this.writeGenericObject(predicateTerm, object);
            } else if (object instanceof Resource) {
                this.writeIndividual((Resource)object);
            } else {
                Literal value = (Literal)object;
                BinaryUtil.writeString(this.out, value.stringValue());
                if (predicateTerm.hasType(64)) {
                    String languageCode = value.getLanguage();
                    Language record = this.languageMap.get(languageCode);
                    this.writeInteger(this.languageSize, record == null ? 0 : record.getIndex());
                }
                if (predicateTerm.hasType(32)) {
                    int index = 0;
                    URI datatype = value.getDatatype();
                    if (datatype != null) {
                        Term datatypeTerm = this.find(datatype.stringValue());
                        index = datatypeTerm.getIndex();
                    }
                    this.writeInteger(this.termSize, index);
                }
            }
        }

        private void writeGenericObject(Term predicateTerm, Value object) throws IOException {
            if (object instanceof Resource) {
                BinaryUtil.writeUnsignedByte(this.out, 128);
                this.writeIndividual((Resource)object);
            } else {
                Literal literal = (Literal)object;
                String language = literal.getLanguage();
                if (language != null) {
                    Language record = this.languageMap.get(language);
                    if (record == this.defaultLanguage) {
                        BinaryUtil.writeUnsignedByte(this.out, 16);
                        BinaryUtil.writeString(this.out, literal.stringValue());
                    } else {
                        BinaryUtil.writeUnsignedByte(this.out, 64);
                        BinaryUtil.writeString(this.out, literal.stringValue());
                        this.writeInteger(this.languageSize, record.getIndex());
                    }
                } else {
                    URI datatype = literal.getDatatype();
                    if (datatype != null && !datatype.equals((Object)XMLSchema.STRING)) {
                        if (predicateTerm.hasType(32)) {
                            BinaryUtil.writeUnsignedByte(this.out, 32);
                            BinaryUtil.writeString(this.out, literal.stringValue());
                            this.writeIRI(datatype);
                        } else {
                            BinaryUtil.writeUnsignedByte(this.out, 8);
                            BinaryUtil.writeString(this.out, literal.stringValue());
                        }
                    } else {
                        BinaryUtil.writeUnsignedByte(this.out, 4);
                        BinaryUtil.writeString(this.out, literal.stringValue());
                    }
                }
            }
        }

        private void writeIndividual(Resource resource) throws IOException {
            if (resource instanceof URI) {
                this.writeIRI((URI)resource);
            } else if (resource instanceof BNode) {
                int index = this.bnodeMap.get(resource.stringValue()) + this.iriCount;
                this.writeInteger(this.termSize, index);
            }
        }

        private void writeIRI(URI iri) throws IOException {
            Term term = this.find(iri.stringValue());
            this.writeInteger(this.termSize, term.getIndex());
        }

        private void writeHeader() throws IOException {
            BinaryUtil.writeUnsignedShort(this.out, 1);
            BinaryUtil.writeUnsignedByte(this.out, this.termSize);
            BinaryUtil.writeUnsignedByte(this.out, this.languageSize);
            BinaryUtil.writeString(this.out, this.defaultLanguage == null ? "" : this.defaultLanguage.getValue());
        }

        private void writeTerm(Term term) throws IOException {
            Collection<Term> list = term.list();
            if (list == null) {
                this.writeTerm(term.getLocalName(), term);
            } else {
                String name = term.getLocalName();
                if (name == null) {
                    name = "";
                }
                if (list.size() == 1) {
                    StringBuilder builder = new StringBuilder();
                    while (list != null && list.size() == 1) {
                        builder.append(term.getLocalName());
                        term = list.iterator().next();
                        list = term.list();
                    }
                }
                this.writeTerm(name, term);
                if (list != null) {
                    this.writeInteger(this.termSize, list.size());
                    for (Term child : list) {
                        this.writeTerm(child);
                    }
                }
            }
        }

        private void writeLanguageList() throws IOException {
            this.writeInteger(this.languageSize, this.languageMap.size());
            int count = 1;
            for (Language language : this.languageMap.values()) {
                language.setIndex(count++);
                BinaryUtil.writeString(this.out, language.getValue());
            }
        }

        private void writeTerm(String localName, Term term) throws IOException {
            BinaryUtil.writeUnsignedByte(this.out, term.getTermType());
            BinaryUtil.writeString(this.out, localName);
            if (term.hasType(8)) {
                Term datatype = term.getDatatype();
                this.writeTermRef(datatype);
            }
        }

        private void writeTermRef(Term term) throws IOException {
            this.writeInteger(this.termSize, term.getIndex());
        }

        private void writeInteger(int size, int value) throws IOException {
            switch (size) {
                case 1: {
                    BinaryUtil.writeUnsignedByte(this.out, value);
                    break;
                }
                case 2: {
                    BinaryUtil.writeUnsignedShort(this.out, value);
                    break;
                }
                default: {
                    this.out.writeInt(value);
                }
            }
        }

        private void buildDictionary(Graph graph) {
            for (Statement s : graph) {
                this.handleStatement(s);
            }
            this.assignTermIndex(this.root);
        }

        private void assignTermIndex(Term parent) {
            int pattern = -3;
            Collection<Term> list = parent.list();
            this.iriCount = 1;
            if (list != null) {
                for (Term term : list) {
                    int type = term.getTermType();
                    if ((type & pattern) != 0) {
                        term.setIndex(this.iriCount++);
                    }
                    this.assignTermIndex(term);
                }
            }
            int size = this.iriCount + this.bnodeMap.size();
            this.termSize = this.integerSize(size);
            this.languageSize = this.integerSize(this.languageMap.size() + 1);
        }

        private int integerSize(int size) {
            return size < MAX_BYTE ? 1 : (size < MAX_SHORT ? 2 : 4);
        }

        private void handleStatement(Statement s) {
            this.handleIndividual(s.getSubject());
            Value object = s.getObject();
            Term term = this.find(s.getPredicate().stringValue(), 0);
            if (object instanceof Resource) {
                this.handleIndividual((Resource)object);
                term.addType(128);
            } else {
                Literal literal = (Literal)s.getObject();
                String language = literal.getLanguage();
                if (language == null) {
                    Language record = this.languageMap.get(language);
                    if (record == null) {
                        record = new Language(language);
                        this.languageMap.put(language, record);
                    } else {
                        record.increment();
                    }
                    if (this.defaultLanguage == null) {
                        this.defaultLanguage = record;
                    } else if (record.getCount() > this.defaultLanguage.getCount()) {
                        this.defaultLanguage = record;
                    }
                    Language prior = term.getLanguage();
                    if (prior == null) {
                        term.addType(16);
                        term.setLanguage(record);
                    } else if (prior != record) {
                        term.addType(64);
                        term.removeType(16);
                    }
                } else {
                    URI thisDatatype = literal.getDatatype();
                    if (thisDatatype != null && !XMLSchema.STRING.equals((Object)thisDatatype)) {
                        URI otherDatatype = term.getDatatypeURI();
                        if (otherDatatype == null) {
                            term.setDatatypeURI(thisDatatype);
                            term.addType(8);
                        } else if (!thisDatatype.equals((Object)otherDatatype)) {
                            term.addType(32);
                            term.removeType(8);
                        }
                    } else {
                        term.addType(4);
                    }
                }
            }
        }

        private void handleIndividual(Resource r) {
            if (r instanceof URI) {
                this.find(r.stringValue(), 1);
            } else {
                String key = r.stringValue();
                if (!this.bnodeMap.containsKey(key)) {
                    Integer value = this.bnodeMap.size();
                    this.bnodeMap.put(key, value);
                }
            }
        }

        private Term find(String iri) {
            return this.find(iri);
        }

        private Term find(String iri, int termType) {
            Term node = this.root;
            TermPart part = new TermPart(iri);
            boolean seek = true;
            do {
                Term child;
                String localName = part.toString();
                Term term = child = seek ? node.get(localName) : null;
                if (child == null) {
                    seek = false;
                    child = new Term(localName);
                    node.add(child);
                }
                if (termType <= 0) continue;
                child.addType(part.more() ? 2 : termType);
            } while (part.next());
            return node;
        }
    }
}

