/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.binary;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BinaryUtil {
    public static int readUnsignedByte(ByteBuffer input) {
        byte value = input.get();
        return value & 0xFF;
    }

    public static int readUnsignedShort(ByteBuffer input) {
        short value = input.getShort();
        return value & 0xFFFF;
    }

    public static void writeUnsignedByte(DataOutputStream data, int value) throws IOException {
        data.writeByte((byte)value);
    }

    public static void writeUnsignedShort(DataOutputStream data, int value) throws IOException {
        data.writeShort((short)value);
    }

    public static void writeString(DataOutputStream data, String value) throws IOException {
        if (value == null) {
            value = "";
        }
        byte[] array = value.getBytes();
        data.write(array);
        data.writeByte(0);
    }

    public static String readString(ByteBuffer data) {
        byte b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (data.hasRemaining() && (b = data.get()) != 0) {
            out.write(b);
        }
        return new String(out.toByteArray());
    }
}

