/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.binary;

import io.konig.core.binary.Language;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.URI;

public class Term {
    private int termType;
    private String localName;
    private Term datatype;
    private Language language;
    private int index;
    private URI datatypeURI;
    private Map<String, Term> kids;

    public Term(String localName) {
        this.localName = localName;
    }

    public void addType(int bits) {
        this.termType |= bits;
    }

    public boolean hasType(int bits) {
        return (bits & this.termType) != 0;
    }

    public void removeType(int bits) {
        this.termType &= ~bits;
    }

    public void add(Term child) {
        if (this.kids == null) {
            this.kids = new HashMap<String, Term>();
        }
        this.kids.put(child.getLocalName(), child);
    }

    public Term get(String localName) {
        return this.kids == null ? null : this.kids.get(localName);
    }

    public int getTermType() {
        return this.termType;
    }

    public void setTermType(int termType) {
        this.termType = termType;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public Term getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Term datatype) {
        this.datatype = datatype;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public int size() {
        return this.kids == null ? 0 : this.kids.size();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Collection<Term> list() {
        return this.kids == null ? null : this.kids.values();
    }

    public URI getDatatypeURI() {
        return this.datatypeURI;
    }

    public void setDatatypeURI(URI datatypeURI) {
        this.datatypeURI = datatypeURI;
    }
}

