/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.binary;

public class TermPart {
    private String value;
    private int start;
    private int end;

    public TermPart(String value) {
        char c;
        this.value = value;
        this.start = 0;
        this.next();
        while (this.end < value.length() && (c = value.charAt(this.end)) == '/') {
            ++this.end;
        }
    }

    public String toString() {
        return this.value.substring(this.start, this.end);
    }

    public boolean more() {
        return this.end < this.value.length();
    }

    public boolean matches(String text) {
        if (text.length() != this.end - this.start) {
            return false;
        }
        int j = this.start;
        for (int i = 0; i < text.length(); ++i) {
            char b;
            char a;
            if ((a = this.value.charAt(j++)) == (b = text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean next() {
        this.start = this.end;
        while (this.end < this.value.length()) {
            char c = this.value.charAt(this.end);
            ++this.end;
            if (c != '/' && c != ':' && c != '#' && c != '?' && c != '&') continue;
            break;
        }
        return this.start < this.value.length();
    }
}

