/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.delta;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.delta.BNodeKey;
import io.konig.core.delta.BNodeKeyFactory;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.vocab.Konig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public class ChangeSetFactory {
    private static final URI KEYLIST = new URIImpl("http://www.konig.io/ns/kcs/keyList");
    private boolean preserveNamedIndividuals;
    private Set<String> ignoreNamespace;

    public Graph createChangeSet(Graph source, Graph target, BNodeKeyFactory factory) {
        Worker worker = new Worker(source, target, factory);
        return worker.compute();
    }

    public Set<String> getIgnoreNamespace() {
        return this.ignoreNamespace;
    }

    public void setIgnoreNamespace(Set<String> ignoreNamespace) {
        this.ignoreNamespace = ignoreNamespace;
    }

    public boolean isPreserveNamedIndividuals() {
        return this.preserveNamedIndividuals;
    }

    public void setPreserveNamedIndividuals(boolean preserveNamedIndividuals) {
        this.preserveNamedIndividuals = preserveNamedIndividuals;
    }

    private class Worker {
        private Graph source;
        private Graph target;
        private BNodeKeyFactory keyFactory;
        private Graph changes;
        private Map<Vertex, Vertex> bnodeMap = new HashMap<Vertex, Vertex>();

        public Worker(Graph source, Graph target, BNodeKeyFactory factory) {
            this.source = source;
            this.target = target;
            this.keyFactory = factory;
            this.changes = new MemoryGraph();
        }

        private Graph compute() {
            this.scanSource();
            this.scanTarget();
            return this.changes;
        }

        private void scanTarget() {
            for (Vertex w : this.target.vertices()) {
                Vertex v;
                if (!(w.getId() instanceof URI)) continue;
                if (ChangeSetFactory.this.ignoreNamespace != null) {
                    URI uri = (URI)w.getId();
                    if (ChangeSetFactory.this.ignoreNamespace.contains(uri.getNamespace())) continue;
                }
                if ((v = this.source.getVertex(w.getId())) != null) continue;
                this.add(w);
            }
        }

        private void scanSource() {
            for (Vertex v : this.source.vertices()) {
                if (!(v.getId() instanceof URI)) continue;
                if (ChangeSetFactory.this.ignoreNamespace != null) {
                    URI uri = (URI)v.getId();
                    if (ChangeSetFactory.this.ignoreNamespace.contains(uri.getNamespace())) continue;
                }
                this.handleSourceURI(v);
            }
        }

        private void handleSourceURI(Vertex v) {
            Vertex w = this.target.getVertex(v.getId());
            if (w == null) {
                if (!ChangeSetFactory.this.preserveNamedIndividuals) {
                    this.remove(v, null);
                }
            } else {
                this.diff(v, w, null);
            }
        }

        private void mapBNodes(Vertex subject1, Vertex subject2, URI predicate, Set<Edge> set1) {
            Set<Edge> set2 = subject2.outProperty(predicate);
            Map<String, Vertex> map2 = this.keyMap(subject2, predicate, set2, this.target);
            for (Edge e : set1) {
                Value value = e.getObject();
                if (!(value instanceof BNode)) continue;
                BNode bnode1 = (BNode)value;
                Vertex object1 = this.source.getVertex((Resource)bnode1);
                BNodeKey bnodeKey = this.keyFactory.createKey(predicate, object1);
                e.setAnnotation(KEYLIST, (Value)bnodeKey);
                String key = bnodeKey.getHash();
                Vertex object2 = map2.get(key);
                if (object2 == null) continue;
                this.bnodeMap.put(object1, object2);
                this.bnodeMap.put(object2, object1);
            }
        }

        private Map<String, Vertex> keyMap(Vertex subject, URI predicate, Set<Edge> objectSet, Graph graph) {
            HashMap<String, Vertex> map = new HashMap<String, Vertex>();
            for (Edge e : objectSet) {
                Value value = e.getObject();
                if (!(value instanceof BNode)) continue;
                BNode bnode = (BNode)value;
                Vertex object = graph.getVertex((Resource)bnode);
                BNodeKey bnodeKey = this.keyFactory.createKey(predicate, object);
                if (bnodeKey == null) {
                    throw new KonigException("BNode key not found for predicate: " + predicate);
                }
                String key = bnodeKey.getHash();
                map.put(key, object);
            }
            return map;
        }

        private boolean diff(Vertex v, Vertex w, BNodeKey bnodeKey) {
            int count = this.diffSource(v, w, bnodeKey);
            return (count += this.diffTarget(v, w)) != 0;
        }

        private int diffTarget(Vertex v, Vertex w) {
            int count = 0;
            Resource subject = v.getId();
            Set<Map.Entry<URI, Set<Edge>>> out = w.outEdges();
            for (Map.Entry<URI, Set<Edge>> entry : out) {
                URI predicate = entry.getKey();
                Set<Edge> set = entry.getValue();
                for (Edge e : set) {
                    Value object2 = e.getObject();
                    if (ChangeSetFactory.this.ignoreNamespace != null && object2 instanceof URI) {
                        URI uri = (URI)object2;
                        if (ChangeSetFactory.this.ignoreNamespace.contains(uri.getNamespace())) continue;
                    }
                    if (object2 instanceof BNode) {
                        BNode bnode2 = (BNode)object2;
                        Vertex vertex2 = this.target.getVertex((Resource)bnode2);
                        Vertex vertex1 = this.bnodeMap.get(vertex2);
                        if (vertex1 != null) continue;
                        this.add(subject, predicate, (Value)vertex2.getId());
                        ++count;
                        this.add(vertex2);
                        continue;
                    }
                    if (v.hasProperty(predicate, object2)) continue;
                    this.add(subject, predicate, object2);
                }
            }
            return count;
        }

        private int add(Vertex v) {
            int count = 0;
            Set<Map.Entry<URI, Set<Edge>>> out = v.outEdges();
            for (Map.Entry<URI, Set<Edge>> entry : out) {
                Set<Edge> set = entry.getValue();
                for (Edge e : set) {
                    this.changes.edge(e).addAnnotation(RDF.TYPE, (Value)Konig.Assertion);
                    ++count;
                    Value object = e.getObject();
                    if (!(object instanceof BNode)) continue;
                    BNode bnode = (BNode)object;
                    count += this.add(this.target.getVertex((Resource)bnode));
                }
            }
            return count;
        }

        private void add(Resource subject, URI predicate, Value object) {
            this.changes.edge(subject, predicate, object).addAnnotation(RDF.TYPE, (Value)Konig.Assertion);
        }

        private int diffSource(Vertex v, Vertex w, BNodeKey bnodeKey) {
            int count = 0;
            Set<Map.Entry<URI, Set<Edge>>> out = v.outEdges();
            for (Map.Entry<URI, Set<Edge>> entry : out) {
                URI predicate = entry.getKey();
                Set<Edge> set = entry.getValue();
                boolean mapBNodes = true;
                URI keyPart = bnodeKey == null ? null : bnodeKey.keyPart(predicate);
                for (Edge e : set) {
                    Value object1 = e.getObject();
                    if (ChangeSetFactory.this.ignoreNamespace != null && object1 instanceof URI) {
                        URI uri = (URI)object1;
                        if (ChangeSetFactory.this.ignoreNamespace.contains(uri.getNamespace())) continue;
                    }
                    if (object1 instanceof BNode) {
                        BNodeKey childKey;
                        if (mapBNodes && this.keyFactory != null) {
                            mapBNodes = false;
                            this.mapBNodes(v, w, predicate, set);
                        }
                        if ((childKey = (BNodeKey)e.removeAnnotation(KEYLIST)) != null) {
                            BNode bnode1 = (BNode)object1;
                            Vertex sourceBNode = this.source.getVertex((Resource)bnode1);
                            Vertex targetBNode = this.bnodeMap.get(sourceBNode);
                            if (targetBNode == null) {
                                this.changes.edge(e).addAnnotation(RDF.TYPE, (Value)Konig.Falsehood);
                                ++count;
                                count += this.removeBNode(sourceBNode, childKey);
                                continue;
                            }
                            Edge edge = this.key(e);
                            if (!this.diff(sourceBNode, targetBNode, childKey)) {
                                BNode doomed = (BNode)edge.getObject();
                                this.removeBNode((Resource)doomed);
                                this.changes.remove(edge);
                                continue;
                            }
                            this.changes.edge(e).addAnnotation(RDF.TYPE, (Value)Konig.KeyValue);
                            continue;
                        }
                        throw new KonigException("TODO: handle the case where keys are not defined");
                    }
                    if (!w.hasProperty(predicate, object1)) {
                        Edge edge = this.changes.edge(e).addAnnotation(RDF.TYPE, (Value)Konig.Falsehood);
                        ++count;
                        if (keyPart == null) continue;
                        edge.addAnnotation(RDF.TYPE, (Value)keyPart);
                        continue;
                    }
                    if (keyPart == null) continue;
                    this.changes.edge(e).addAnnotation(RDF.TYPE, (Value)keyPart);
                }
            }
            return count;
        }

        private int removeBNode(Resource doomed) {
            int count = 0;
            Vertex v = this.changes.getVertex(doomed);
            Set<Edge> out = v.outEdgeSet();
            for (Edge edge : out) {
                this.changes.remove(edge);
                --count;
                Value object = edge.getObject();
                if (!(object instanceof BNode)) continue;
                count += this.removeBNode((Resource)((BNode)object));
            }
            return count;
        }

        private int removeBNode(Vertex bnode, BNodeKey key) {
            int count = 0;
            Set<Edge> out = bnode.outEdgeSet();
            for (Edge e : out) {
                URI predicate = e.getPredicate();
                URI part = key.keyPart(predicate);
                if (part == null) continue;
                this.changes.edge(e).addAnnotation(RDF.TYPE, (Value)part);
                ++count;
            }
            return count;
        }

        private Edge key(Edge e) {
            Edge edge = this.changes.edge(e);
            edge.addAnnotation(RDF.TYPE, (Value)Konig.KeyValue);
            return edge;
        }

        private void removeEdge(Edge e) {
            this.changes.edge(e).addAnnotation(RDF.TYPE, (Value)Konig.Falsehood);
        }

        private void remove(Vertex v, BNodeKey bnodeKey) {
            Set<Map.Entry<URI, Set<Edge>>> out = v.outEdges();
            Graph g = v.getGraph();
            for (Map.Entry<URI, Set<Edge>> entry : out) {
                Set<Edge> set = entry.getValue();
                URI predicate = entry.getKey();
                URI part = bnodeKey == null ? null : bnodeKey.keyPart(predicate);
                for (Edge e : set) {
                    Value object;
                    if (part != null) {
                        this.changes.edge(e).addAnnotation(RDF.TYPE, (Value)part);
                    } else {
                        this.removeEdge(e);
                    }
                    if (!((object = e.getObject()) instanceof BNode)) continue;
                    Vertex w = g.getVertex((Resource)((BNode)object));
                    BNodeKey childKey = this.bnodeKey(predicate, w);
                    this.remove(w, childKey);
                }
            }
        }

        private BNodeKey bnodeKey(URI predicate, Vertex object) {
            return this.keyFactory == null ? null : this.keyFactory.createKey(predicate, object);
        }
    }
}

