/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.delta;

import io.konig.core.Graph;
import io.konig.core.delta.FileChangeHandler;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.io.ContextValueFactory;
import io.konig.core.io.GraphLoadHandler;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.openrdf.model.Resource;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.turtle.TurtleParser;

public class FileChangeManager {
    public void applyChanges(File sourceDir, File targetDir, FileChangeHandler handler) throws IOException, RDFParseException, RDFHandlerException {
        MemoryGraph targetGraph = new MemoryGraph();
        this.loadAll(targetDir, targetGraph);
    }

    private void loadAll(File file, Graph graph) throws IOException, RDFParseException, RDFHandlerException {
        if (file.isDirectory()) {
            File[] kids;
            for (File child : kids = file.listFiles()) {
                this.loadAll(child, graph);
            }
        } else {
            FileReader input = new FileReader(file);
            ContextValueFactory valueFactory = new ContextValueFactory(this.fileResource(file));
            TurtleParser parser = new TurtleParser((ValueFactory)valueFactory);
            GraphLoadHandler handler = new GraphLoadHandler(graph);
            parser.setRDFHandler((RDFHandler)handler);
            parser.parse((Reader)input, "");
        }
    }

    private Resource fileResource(File file) {
        String path = file.getAbsolutePath().replace('\\', '/');
        StringBuilder builder = new StringBuilder();
        builder.append("file://localhost/");
        builder.append(path);
        return new URIImpl(builder.toString());
    }
}

