/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.delta;

import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.delta.ChangeSetReportWriter;
import io.konig.core.delta.FileChangeHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class FileChangeReporter
implements FileChangeHandler {
    private static final String SEPARATOR = "=============================================================================";
    private static final String CREATE = "CREATE ";
    private static final String UPDATE = "UPDATE ";
    private static final String DELETE = "DELETE ";
    private PrintWriter out;
    private String rootDir;
    private ChangeSetReportWriter reporter;

    public FileChangeReporter(File rootDir, PrintWriter out, ChangeSetReportWriter reporter) {
        this.rootDir = rootDir.getAbsolutePath();
        this.out = out;
        this.reporter = reporter;
    }

    @Override
    public void deleteFile(File file) {
        String path = this.path(file);
        this.out.println(SEPARATOR);
        this.out.print(DELETE);
        this.out.println(path);
        this.out.println();
    }

    private String path(File file) {
        String full = file.getAbsolutePath();
        if (!full.startsWith(this.rootDir)) {
            throw new KonigException("Invalid path: " + full);
        }
        return full.substring(this.rootDir.length() + 1);
    }

    @Override
    public void createFile(File file, Graph contents) throws IOException {
        String path = this.path(file);
        this.out.println(SEPARATOR);
        this.out.print(CREATE);
        this.out.println(path);
        this.out.println();
        this.reporter.write(contents, this.out);
    }

    @Override
    public void modifyFile(File file, Graph changeSet) throws IOException {
        String path = this.path(file);
        this.out.println(SEPARATOR);
        this.out.print(UPDATE);
        this.out.println(path);
        this.out.println();
        this.reporter.write(changeSet, this.out);
    }
}

