/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.delta;

import io.konig.core.Vertex;
import io.konig.core.delta.BNodeKey;
import io.konig.core.delta.BNodeKeyFactory;
import io.konig.core.delta.ShaBNodeHasher;
import io.konig.core.vocab.Konig;
import java.util.HashMap;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDFS;

public class OwlRestrictionKeyFactory
implements BNodeKeyFactory {
    @Override
    public BNodeKey createKey(URI predicate, Vertex object) {
        URI constraint;
        URI onProperty;
        if (RDFS.SUBCLASSOF.equals((Object)predicate) && (onProperty = object.getURI(OWL.ONPROPERTY)) != null && (constraint = this.getConstraint(object)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(onProperty.stringValue());
            builder.append('!');
            builder.append(constraint.stringValue());
            String text = builder.toString();
            String hash = ShaBNodeHasher.SHA1(text);
            HashMap<String, URI> map = new HashMap<String, URI>();
            map.put(OWL.ONPROPERTY.stringValue(), Konig.KeyValue);
            map.put(constraint.stringValue(), Konig.KeyTerm);
            return new BNodeKey(hash, map, this);
        }
        return null;
    }

    private URI getConstraint(Vertex object) {
        return object.getValue(OWL.MINCARDINALITY) != null ? OWL.MINCARDINALITY : (object.getValue(OWL.MAXCARDINALITY) != null ? OWL.MAXCARDINALITY : (object.getValue(OWL.CARDINALITY) != null ? OWL.CARDINALITY : (object.getValue(OWL.HASVALUE) != null ? OWL.HASVALUE : (object.getValue(OWL.ALLVALUESFROM) != null ? OWL.ALLVALUESFROM : (object.getValue(OWL.SOMEVALUESFROM) != null ? OWL.SOMEVALUESFROM : null)))));
    }
}

