/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.delta;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.Vertex;
import io.konig.core.delta.ChangeSetReportWriter;
import io.konig.core.vocab.Konig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class PlainTextChangeSetReportWriter
implements ChangeSetReportWriter {
    private static final String ADD = "+    ";
    private static final String REMOVE = "-    ";
    private static final String KEYVALUE = "*    ";
    private static final String KEYTERM = "*    ";
    private static final String ADD_KEYVALUE = "+    ";
    private static final String REMOVE_KEYVALUE = "-    ";
    private static final String ADD_KEYTERM = "+    ";
    private static final String REMOVE_KEYTERM = "-    ";
    private static final String NONE = "?    ";
    private NamespaceManager nsManager;
    private int indentSize = 4;
    private Set<URI> exclude = new HashSet<URI>();

    public PlainTextChangeSetReportWriter(NamespaceManager nsManager) {
        this.nsManager = nsManager;
    }

    public void exclude(URI term) {
        this.exclude.add(term);
    }

    @Override
    public void write(Graph changeSet, Writer writer) throws IOException {
        Worker worker = new Worker(changeSet, writer);
        worker.run();
    }

    @Override
    public void write(Graph changeSet, OutputStream out) throws IOException {
        this.write(changeSet, new OutputStreamWriter(out));
    }

    private static class Context {
        Resource lastSubject;
        URI lastPredicate;

        private Context() {
        }
    }

    private class Worker {
        Graph graph;
        PrintWriter writer;
        List<Context> stack = new ArrayList<Context>();

        public Worker(Graph graph, Writer writer) {
            this.graph = graph;
            this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        }

        public void run() {
            this.writeAll(this.graph, false);
            if (this.graph.size() > 0) {
                while (!this.stack.isEmpty()) {
                    Context context = this.pop();
                    if (!(context.lastSubject instanceof BNode)) break;
                    this.writer.print(']');
                }
                this.writer.println(" .");
            } else {
                this.writer.println();
            }
            this.writer.flush();
        }

        private Context pop() {
            return this.stack.isEmpty() ? null : this.stack.remove(this.stack.size() - 1);
        }

        private void writeAll(Collection<Edge> collection, boolean includeBNode) {
            for (Edge e : collection) {
                URI objectURI;
                Resource subject = e.getSubject();
                Value object = e.getObject();
                URI subjectURI = subject instanceof URI ? (URI)subject : null;
                URI uRI = objectURI = object instanceof URI ? (URI)object : null;
                if (PlainTextChangeSetReportWriter.this.exclude.contains(e.getPredicate()) || PlainTextChangeSetReportWriter.this.exclude.contains(subjectURI) || PlainTextChangeSetReportWriter.this.exclude.contains(objectURI) || !includeBNode && !(e.getSubject() instanceof URI)) continue;
                this.handleStatement(e);
                if (!(e.getObject() instanceof BNode)) continue;
                BNode bnode = (BNode)e.getObject();
                Vertex vertex = this.graph.getVertex((Resource)bnode);
                Set<Edge> set = vertex.outEdgeSet();
                this.writeAll(set, true);
            }
        }

        private void handleStatement(Edge edge) {
            Context context = this.peek();
            if (context == null) {
                context = new Context();
                this.stack.add(context);
            }
            Resource subject = edge.getSubject();
            URI predicate = edge.getPredicate();
            Value object = edge.getObject();
            context = this.closeStatement(context, edge);
            String function = this.functionString(edge);
            this.writer.print(function);
            this.indent();
            if (context.lastSubject == null && subject instanceof BNode) {
                context.lastSubject = subject;
            }
            if (subject.equals(context.lastSubject)) {
                this.tab();
            } else {
                context.lastSubject = subject;
                context.lastPredicate = null;
                String id = this.resourceId(subject);
                this.writer.print(id);
            }
            if (predicate.equals((Object)context.lastPredicate)) {
                this.tab();
            } else {
                context.lastPredicate = predicate;
                String text = this.resourceId((Resource)predicate);
                this.writer.print(' ');
                this.writer.print(text);
                this.writer.print(' ');
            }
            String value = this.value(object);
            this.writer.print(value);
            if (object instanceof BNode) {
                Context next = new Context();
                this.stack.add(next);
            }
        }

        private Context closeStatement(Context context, Edge edge) {
            if (edge.getSubject().equals(context.lastSubject)) {
                if (edge.getPredicate().equals((Object)context.lastPredicate)) {
                    this.writer.println(" ,");
                } else {
                    this.writer.println(" ;");
                }
            } else if (context.lastSubject instanceof BNode) {
                this.stack.remove(this.stack.size() - 1);
                context = this.peek();
                this.writer.print(']');
                context = this.closeStatement(context, edge);
            } else if (context.lastSubject instanceof URI) {
                this.writer.println(" .");
            } else {
                this.writer.println();
            }
            return context;
        }

        private String value(Value object) {
            if (object instanceof Resource) {
                return this.resourceId((Resource)object);
            }
            Literal literal = (Literal)object;
            String text = literal.stringValue();
            String lang = literal.getLanguage();
            if (lang != null) {
                StringBuilder builder = new StringBuilder();
                builder.append('\"');
                builder.append(text);
                builder.append("\"@");
                builder.append(lang);
                return builder.toString();
            }
            if (text.equals("true") || text.equals("false")) {
                return text;
            }
            try {
                Double.parseDouble(text);
                return text;
            }
            catch (Throwable oops) {
                StringBuilder builder = new StringBuilder();
                builder.append('\"');
                builder.append(text);
                builder.append('\"');
                return builder.toString();
            }
        }

        private String resourceId(Resource node) {
            StringBuilder builder = new StringBuilder();
            if (node instanceof BNode) {
                return "[";
            }
            URI uri = (URI)node;
            String namespace = uri.getNamespace();
            Namespace ns = PlainTextChangeSetReportWriter.this.nsManager.findByName(namespace);
            if (ns != null) {
                builder.append(ns.getPrefix());
                builder.append(':');
                builder.append(uri.getLocalName());
            } else {
                builder.append('<');
                builder.append(node.stringValue());
                builder.append('>');
            }
            return builder.toString();
        }

        private void tab() {
            for (int i = 0; i < PlainTextChangeSetReportWriter.this.indentSize; ++i) {
                this.writer.print(' ');
            }
        }

        private Context peek() {
            return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
        }

        private void indent() {
            int width = (this.stack.size() - 1) * PlainTextChangeSetReportWriter.this.indentSize;
            for (int i = 0; i < width; ++i) {
                this.writer.print(' ');
            }
        }

        private String functionString(Edge edge) {
            Value value = edge.getAnnotation(RDF.TYPE);
            String result = Konig.Assertion.equals((Object)value) ? "+    " : (Konig.Falsehood.equals((Object)value) ? "-    " : (Konig.KeyValue.equals((Object)value) ? "*    " : (Konig.KeyTerm.equals((Object)value) ? "*    " : (this.match(edge, Konig.Falsehood, Konig.KeyValue, value) ? "-    " : (this.match(edge, Konig.Assertion, Konig.KeyValue, value) ? "+    " : (this.match(edge, Konig.Falsehood, Konig.KeyTerm, value) ? "-    " : (this.match(edge, Konig.Assertion, Konig.KeyTerm, value) ? "+    " : PlainTextChangeSetReportWriter.NONE)))))));
            return result;
        }

        private boolean match(Edge e, URI a, URI b, Value value) {
            return e.matches((Value)a, value) && e.matches((Value)b, value);
        }
    }
}

