/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.delta;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.delta.BNodeHasher;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;

public class ShaBNodeHasher
implements BNodeHasher {
    @Override
    public String createHash(URI predicate, Vertex object) {
        Graph graph = object.getGraph();
        Set<Edge> set = object.outEdgeSet();
        List<Pair> list = this.toPairList(set, graph);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        for (Pair pair : list) {
            builder.append(pair.predicate.stringValue());
            builder.append(' ');
            builder.append(pair.value);
            builder.append('|');
        }
        String text = builder.toString();
        return ShaBNodeHasher.SHA1(text);
    }

    private List<Pair> toPairList(Set<Edge> set, Graph graph) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Edge e : set) {
            list.add(this.toPair(e, graph));
        }
        return list;
    }

    private Pair toPair(Edge e, Graph graph) {
        URI predicate = e.getPredicate();
        Value object = e.getObject();
        String value = null;
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            String language = literal.getLanguage();
            URI type = literal.getDatatype();
            if (type.equals((Object)XMLSchema.STRING)) {
                type = null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append('\"');
            builder.append(literal.getLabel());
            builder.append('\"');
            if (language != null) {
                builder.append('@');
                builder.append(language);
            } else if (type != null) {
                builder.append('^');
                builder.append(type.stringValue());
            }
            value = builder.toString();
        } else if (object instanceof URI) {
            value = object.stringValue();
        } else {
            Resource id = (Resource)object;
            Vertex v = graph.getVertex(id);
            value = this.createHash(predicate, v);
        }
        return new Pair(predicate, value);
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String SHA1(String text) throws KonigException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] sha1hash = new byte[40];
            md.update(text.getBytes("iso-8859-1"), 0, text.length());
            sha1hash = md.digest();
            return ShaBNodeHasher.convertToHex(sha1hash);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new KonigException(e);
        }
    }

    static class Pair
    implements Comparable<Pair> {
        URI predicate;
        String value;

        public Pair(URI predicate, String value) {
            this.predicate = predicate;
            this.value = value;
        }

        @Override
        public int compareTo(Pair other) {
            int result = this.predicate.stringValue().compareTo(other.predicate.stringValue());
            if (result == 0) {
                result = this.value.compareTo(other.value);
            }
            return result;
        }
    }
}

