/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.delta;

import io.konig.core.Vertex;
import io.konig.core.delta.BNodeKey;
import io.konig.core.delta.BNodeKeyFactory;
import io.konig.core.delta.ShaBNodeHasher;
import io.konig.core.vocab.Konig;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class SimpleKeyFactory
implements BNodeKeyFactory {
    private URI accessor;
    private URI keyPredicate;
    private Map<String, URI> part = new HashMap<String, URI>();

    public SimpleKeyFactory(URI accessor, URI keyPredicate) {
        this.accessor = accessor;
        this.keyPredicate = keyPredicate;
        this.part.put(keyPredicate.stringValue(), Konig.KeyValue);
    }

    @Override
    public BNodeKey createKey(URI predicate, Vertex object) {
        if (this.accessor.equals((Object)predicate)) {
            Literal literal;
            String lang;
            Value value = object.getValue(this.keyPredicate);
            StringBuilder builder = new StringBuilder();
            builder.append(predicate.stringValue());
            builder.append('!');
            if (value instanceof BNode) {
                builder.append("_:");
            }
            builder.append(value.stringValue());
            if (value instanceof Literal && (lang = (literal = (Literal)value).getLanguage()) != null) {
                builder.append('@');
                builder.append(lang);
            }
            String text = builder.toString();
            String hash = ShaBNodeHasher.SHA1(text);
            return new BNodeKey(hash, this.part, this);
        }
        return null;
    }
}

