/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.extract;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.extract.ExtractException;
import io.konig.core.impl.RdfUtil;
import io.konig.core.vocab.SH;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class OntologyExtractor {
    public void extract(Vertex ontology, Graph target) throws ExtractException {
        Worker worker = new Worker(ontology, target);
        worker.run();
    }

    public Set<String> shapeNamespaces(Graph graph) {
        HashSet<String> set = new HashSet<String>();
        List<Vertex> list = graph.v((Resource)SH.Shape).in(RDF.TYPE).toVertexList();
        for (Vertex v : list) {
            Resource id = v.getId();
            if (!(id instanceof URI)) continue;
            URI uri = (URI)id;
            set.add(uri.getNamespace());
        }
        return set;
    }

    public Set<String> collectOwlOntologies(Graph source, Set<String> exclude) {
        HashSet<String> result = new HashSet<String>();
        List<Vertex> list = source.v((Resource)OWL.ONTOLOGY).in(RDF.TYPE).isIRI().toVertexList();
        for (Vertex v : list) {
            Resource id = v.getId();
            String value = id.stringValue();
            if (exclude.contains(value)) continue;
            result.add(value);
        }
        return result;
    }

    public void collectShapeOntologies(Graph source, Set<String> namespaceSet, Graph target) {
        ArrayList<String> list = new ArrayList<String>(namespaceSet);
        Collections.sort(list);
        for (String ns : list) {
            Vertex v = source.getVertex((Resource)new URIImpl(ns));
            RdfUtil.deepCopy(v, target);
        }
    }

    private class Worker {
        private Vertex ontology;
        private Graph source;
        private Graph target;
        private List<Vertex> classList = new ArrayList<Vertex>();
        private List<Vertex> propertyList = new ArrayList<Vertex>();
        private List<Vertex> namedIndividualList = new ArrayList<Vertex>();
        private List<Vertex> otherList = new ArrayList<Vertex>();
        private OwlReasoner reasoner;

        private Worker(Vertex ontology, Graph target) {
            this.ontology = ontology;
            this.target = target;
            this.source = ontology.getGraph();
            this.reasoner = new OwlReasoner(this.source);
        }

        private void run() throws ExtractException {
            this.copyOntologyAttributes();
            this.collectElements();
            this.copyList(this.classList);
            this.copyList(this.propertyList);
            this.copyList(this.namedIndividualList);
            this.copyList(this.otherList);
        }

        private void copyList(List<Vertex> list) {
            this.sortByLocalName(list);
            for (Vertex v : list) {
                this.copy(v);
            }
        }

        private void sortByLocalName(List<Vertex> list) {
            Collections.sort(list, new Comparator<Vertex>(){

                @Override
                public int compare(Vertex a, Vertex b) {
                    String x = Worker.this.localName(a.getId());
                    String y = Worker.this.localName(b.getId());
                    return x.compareTo(y);
                }
            });
        }

        private String localName(Resource resource) {
            return resource instanceof URI ? ((URI)resource).getLocalName() : resource.stringValue();
        }

        private String namespace(Resource resource) {
            return resource instanceof URI ? ((URI)resource).getNamespace() : null;
        }

        private void collectElements() throws ExtractException {
            Resource id = this.ontology.getId();
            String namespace = this.namespace(id);
            if (namespace == null) {
                throw new ExtractException("The supplied ontology cannot be blank node");
            }
            for (Vertex v : this.source.vertices()) {
                id = v.getId();
                if (!(id instanceof URI) || !id.stringValue().startsWith(namespace)) continue;
                this.collectElement(v);
            }
        }

        private void collectElement(Vertex v) {
            if (v.hasProperty(RDF.TYPE, (Value)OWL.CLASS) || v.hasProperty(RDF.TYPE, (Value)RDFS.CLASS)) {
                this.classList.add(v);
            } else if (v.hasProperty(RDF.TYPE, (Value)RDF.PROPERTY) || v.hasProperty(RDF.TYPE, (Value)OWL.OBJECTPROPERTY) || v.hasProperty(RDF.TYPE, (Value)OWL.DATATYPEPROPERTY) || v.hasProperty(RDF.TYPE, (Value)OWL.INVERSEFUNCTIONALPROPERTY)) {
                this.propertyList.add(v);
            } else if (this.reasoner.isEnumerationMember(v.getId())) {
                this.namedIndividualList.add(v);
            } else {
                this.otherList.add(v);
            }
        }

        private void copyOntologyAttributes() {
            this.copy(this.ontology);
        }

        private void copy(Vertex v) {
            Set<Edge> out = v.outEdgeSet();
            for (Edge e : out) {
                this.target.add(e);
                Value object = e.getObject();
                if (!(object instanceof BNode)) continue;
                Vertex w = this.source.getVertex((Resource)object);
                this.copy(w);
            }
        }
    }
}

