/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.extract;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Vertex;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class ResourceExtractor {
    private Set<URI> wanted = new HashSet<URI>();

    public void include(URI predicate) {
        this.wanted.add(predicate);
    }

    public void extract(Vertex subject, Graph target) {
        Graph source = subject.getGraph();
        Set<Edge> out = subject.outEdgeSet();
        for (Edge e : out) {
            target.edge(e);
            Value object = e.getObject();
            if (!(object instanceof BNode) && !this.wanted.contains(e.getPredicate())) continue;
            Resource node = (Resource)object;
            Vertex v = source.getVertex(node);
            this.extract(v, target);
        }
    }
}

