/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Context;
import io.konig.core.Term;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicContext
implements Context {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(BasicContext.class);
    private Map<String, Term> map = new HashMap<String, Term>();
    private List<Term> list = new ArrayList<Term>();
    private BasicContext inverse;
    private boolean compiled;
    private String iri;
    private String vendorType;
    private long versionNumber;

    public BasicContext(String iri) {
        this.iri = iri;
    }

    @Override
    public String getLanguage() {
        return null;
    }

    @Override
    public String getContextIRI() {
        return this.iri;
    }

    @Override
    public void setContextIRI(String iri) {
        this.iri = iri;
    }

    @Override
    public Term addTerm(String key, String id) {
        Term term = new Term(key, id, null, null);
        this.add(term);
        return term;
    }

    @Override
    public List<Term> asList() {
        return this.list;
    }

    @Override
    public String alias(String keyword) {
        BasicContext inverse = this.inverse();
        Term term = inverse.getTerm(keyword);
        return term == null ? keyword : term.getKey();
    }

    @Override
    public BasicContext inverse() {
        if (!this.compiled) {
            this.compile();
        }
        if (this.inverse == null) {
            this.inverse = new BasicContext(this.iri);
            for (Term term : this.list) {
                this.inverse.list.add(term);
                URI id = term.getExpandedId();
                if (id != null) {
                    this.inverse.map.put(id.stringValue(), term);
                    continue;
                }
                String iri = term.getId();
                if (iri == null) continue;
                this.inverse.map.put(iri, term);
            }
        }
        return this.inverse;
    }

    @Override
    public void add(Term term) {
        int index = this.list.size();
        term.setIndex(index);
        this.map.put(term.getKey(), term);
        this.list.add(term);
        this.compiled = false;
        this.inverse = null;
    }

    @Override
    public Term getTerm(String key) {
        return this.map.get(key);
    }

    @Override
    public String expandIRI(String value) {
        String prefix;
        String expandedPrefix;
        String id;
        Term term = this.getTerm(value);
        if (term != null && (id = term.getId()) != null) {
            return this.expandIRI(id);
        }
        int colon = value.indexOf(58);
        if (colon > 0 && (expandedPrefix = this.expandIRI(prefix = value.substring(0, colon))) != prefix) {
            String localName = value.substring(colon + 1);
            return expandedPrefix + localName;
        }
        return value;
    }

    @Override
    public void compile() {
        if (!this.compiled) {
            this.compiled = true;
            for (int i = 0; i < this.list.size(); ++i) {
                String expandedType;
                String type;
                Term term = this.list.get(i);
                term.setIndex(i);
                String id = term.getId();
                if (id != null) {
                    String expandedId = this.expandIRI(id);
                    term.setExpandedId((URI)new URIImpl(expandedId));
                }
                if ((type = term.getType()) == null || (expandedType = this.expandIRI(type)) == type) continue;
                term.setExpandedType((URI)new URIImpl(expandedType));
            }
        }
    }

    @Override
    public void sort() {
        Collections.sort(this.list);
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).setIndex(i);
        }
    }

    @Override
    public void toJson(JsonGenerator json) throws IOException {
        json.writeStartObject();
        for (Term term : this.list) {
            json.writeFieldName(term.getKey());
            term.toJson(json);
        }
        json.writeEndObject();
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            JsonFactory factory = new JsonFactory();
            JsonGenerator json = factory.createGenerator((Writer)writer);
            json.useDefaultPrettyPrinter();
            json.writeStartObject();
            json.writeFieldName("@context");
            this.toJson(json);
            if (this.iri != null) {
                json.writeStringField("@id", this.iri);
            }
            if (this.vendorType != null) {
                json.writeStringField("vendorType", this.vendorType);
            }
            if (this.versionNumber > 0L) {
                json.writeNumberField("versionNumber", this.versionNumber);
            }
            json.writeEndObject();
            json.flush();
            return writer.toString();
        }
        catch (Throwable oops) {
            logger.warn("Failed to produce string representation of BasicContext", oops);
            return BasicContext.class.getSimpleName();
        }
    }

    @Override
    public String getVendorType() {
        return this.vendorType;
    }

    @Override
    public void setVendorType(String mediaType) {
        this.vendorType = mediaType;
    }

    @Override
    public long getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public void setVersionNumber(long versionNumber) {
        this.versionNumber = versionNumber;
    }
}

