/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Context;
import io.konig.core.Term;
import io.konig.core.impl.BasicContext;
import io.konig.core.io.PrettyPrintWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class ChainedContext
implements Context {
    private static final long serialVersionUID = 1L;
    private Context parent;
    private Context self;
    private List<Term> termList;
    private Context inverse;
    private long versionNumber;
    private boolean compiled = false;

    public ChainedContext(Context parent, Context self) {
        this.parent = parent;
        this.self = self;
    }

    public Context getParent() {
        return this.parent;
    }

    public Context getDefaultContext() {
        return this.self;
    }

    @Override
    public String getLanguage() {
        String language = this.self.getLanguage();
        if (language == null && this.parent != null) {
            language = this.parent.getLanguage();
        }
        return language;
    }

    @Override
    public String getContextIRI() {
        return this.self.getContextIRI();
    }

    @Override
    public void setContextIRI(String iri) {
        this.self.setContextIRI(iri);
    }

    @Override
    public Term addTerm(String key, String id) {
        Term term = new Term(key, id, null);
        this.add(term);
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Term> asList() {
        if (this.termList == null) {
            ChainedContext chainedContext = this;
            synchronized (chainedContext) {
                if (this.termList == null) {
                    this.termList = new ArrayList<Term>(this.self.asList());
                    if (this.parent != null) {
                        List<Term> parentList = this.parent.asList();
                        for (Term term : parentList) {
                            Term other = this.self.getTerm(term.getKey());
                            if (other != null) continue;
                            this.termList.add(term);
                        }
                    }
                }
            }
        }
        return this.termList;
    }

    @Override
    public String alias(String keyword) {
        String alias = this.self.alias(keyword);
        if (alias == null && this.parent != null) {
            alias = this.parent.alias(keyword);
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context inverse() {
        if (this.inverse == null) {
            ChainedContext chainedContext = this;
            synchronized (chainedContext) {
                if (this.inverse == null) {
                    BasicContext union = new BasicContext(null);
                    List<Term> list = this.asList();
                    for (Term term : list) {
                        union.add(term);
                    }
                    this.inverse = union.inverse();
                }
            }
        }
        return this.inverse;
    }

    @Override
    public void add(Term term) {
        this.self.add(term);
        this.compiled = false;
        this.inverse = null;
    }

    @Override
    public Term getTerm(String key) {
        Term term = this.self.getTerm(key);
        if (term == null && this.parent != null) {
            term = this.parent.getTerm(key);
        }
        return term;
    }

    @Override
    public String expandIRI(String value) {
        String prefix;
        String expandedPrefix;
        String id;
        Term term = this.getTerm(value);
        if (term != null && (id = term.getId()) != null) {
            return this.expandIRI(id);
        }
        int colon = value.indexOf(58);
        if (colon > 0 && (expandedPrefix = this.expandIRI(prefix = value.substring(0, colon))) != prefix) {
            String localName = value.substring(colon + 1);
            return expandedPrefix + localName;
        }
        return value;
    }

    @Override
    public void compile() {
        if (this.parent != null) {
            this.parent.compile();
        }
        if (!this.compiled) {
            this.compiled = true;
            List<Term> list = this.self.asList();
            for (int i = 0; i < list.size(); ++i) {
                String expandedType;
                String type;
                Term term = list.get(i);
                term.setIndex(i);
                String id = term.getId();
                if (id != null) {
                    String expandedId = this.expandIRI(id);
                    term.setExpandedId((URI)new URIImpl(expandedId));
                }
                if ((type = term.getType()) == null || (expandedType = this.expandIRI(type)) == type) continue;
                term.setExpandedType((URI)new URIImpl(expandedType));
            }
        }
    }

    @Override
    public void sort() {
        this.self.sort();
    }

    @Override
    public void toJson(JsonGenerator json) throws IOException {
        String iri = this.self.getContextIRI();
        if (iri != null) {
            json.writeString(iri);
        } else {
            this.self.toJson(json);
        }
    }

    @Override
    public String getVendorType() {
        return this.parent != null ? this.parent.getVendorType() : this.self.getVendorType();
    }

    @Override
    public void setVendorType(String mediaType) {
        throw new RuntimeException("Method not supported");
    }

    @Override
    public long getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public void setVersionNumber(long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        PrettyPrintWriter out = new PrettyPrintWriter(buffer);
        this.print(out);
        out.close();
        return buffer.toString();
    }

    public void print(PrettyPrintWriter out) {
        List<Term> termList = this.asList();
        String comma = "";
        out.print('{');
        out.pushIndent();
        for (Term term : termList) {
            out.println(comma);
            comma = ",";
            term.print(out);
        }
        out.println();
        out.popIndent();
        out.indent();
        out.print('}');
    }
}

