/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Context;
import io.konig.core.ContextManager;
import io.konig.core.io.ContextReader;
import io.konig.core.util.PathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.URI;

public class ClasspathContextManager
implements ContextManager {
    private static final String BASE = "jsonld/context/";
    private Map<String, Context> contextMap = new HashMap<String, Context>();

    @Override
    public List<String> listContexts() {
        return new ArrayList<String>(this.contextMap.keySet());
    }

    @Override
    public void add(Context context) {
        String id = context.getContextIRI();
        this.contextMap.put(id, context);
    }

    @Override
    public Context getContextByURI(URI contextURI) {
        return this.getContextByURI(contextURI.stringValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context getContextByURI(String contextURI) {
        Context result = this.contextMap.get(contextURI);
        if (result == null) {
            String filePath = BASE + PathUtil.toFilePath(contextURI);
            InputStream input = this.getClass().getClassLoader().getResourceAsStream(filePath);
            try {
                ContextReader contextParser = new ContextReader(new ContextGetter());
                result = contextParser.read(input);
                result.compile();
                result.setContextIRI(contextURI);
                this.add(result);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    @Override
    public Context getContextByMediaType(String mediaType) {
        return null;
    }

    @Override
    public Context getContextByVersionNumber(long versionNumber) {
        return null;
    }

    @Override
    public Context getUniversalContext() {
        return null;
    }

    class ContextGetter
    implements ContextManager {
        ContextGetter() {
        }

        @Override
        public List<String> listContexts() {
            return ClasspathContextManager.this.listContexts();
        }

        @Override
        public void add(Context context) {
            ClasspathContextManager.this.add(context);
        }

        @Override
        public Context getContextByURI(URI contextURI) {
            return this.getContextByURI(contextURI.stringValue());
        }

        @Override
        public Context getContextByURI(String contextURI) {
            return (Context)ClasspathContextManager.this.contextMap.get(contextURI);
        }

        @Override
        public Context getContextByMediaType(String mediaType) {
            return null;
        }

        @Override
        public Context getContextByVersionNumber(long versionNumber) {
            return null;
        }

        @Override
        public Context getUniversalContext() {
            return null;
        }
    }
}

