/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Context;
import io.konig.core.Term;
import io.konig.core.impl.ChainedContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeContext
implements Context {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CompositeContext.class);
    private List<ChainedContext> list = new ArrayList<ChainedContext>();
    private ChainedContext last;
    private String iri;
    private boolean compiled;
    private String vendorType;
    private long versionNumber;

    public void append(Context context) {
        this.last = new ChainedContext(this.last, context);
        this.list.add(this.last);
    }

    public ChainedContext getLast() {
        return this.last;
    }

    @Override
    public String getLanguage() {
        return this.last.getLanguage();
    }

    @Override
    public String getContextIRI() {
        return this.iri;
    }

    @Override
    public void setContextIRI(String iri) {
        this.iri = iri;
    }

    @Override
    public Term addTerm(String key, String id) {
        return this.last.addTerm(key, id);
    }

    @Override
    public List<Term> asList() {
        return this.last.asList();
    }

    @Override
    public String alias(String keyword) {
        return this.last.alias(keyword);
    }

    @Override
    public Context inverse() {
        return this.last.inverse();
    }

    @Override
    public void add(Term term) {
        this.last.add(term);
    }

    @Override
    public Term getTerm(String key) {
        return this.last.getTerm(key);
    }

    @Override
    public String expandIRI(String value) {
        return this.last.expandIRI(value);
    }

    @Override
    public void compile() {
        if (!this.compiled) {
            ChainedContext c = this.last;
            while (c != null) {
                c.compile();
                Context parent = c.getParent();
                c = parent instanceof ChainedContext ? (ChainedContext)parent : null;
            }
        }
    }

    @Override
    public void sort() {
    }

    @Override
    public void toJson(JsonGenerator json) throws IOException {
        json.writeStartArray();
        for (ChainedContext context : this.list) {
            context.toJson(json);
        }
        json.writeEndArray();
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            JsonFactory factory = new JsonFactory();
            JsonGenerator json = factory.createGenerator((Writer)writer);
            json.useDefaultPrettyPrinter();
            this.toJson(json);
            json.flush();
            return writer.toString();
        }
        catch (Throwable oops) {
            logger.warn("Failed to produce string representation of CompositeContext", oops);
            return CompositeContext.class.getSimpleName();
        }
    }

    @Override
    public String getVendorType() {
        return this.vendorType;
    }

    @Override
    public void setVendorType(String mediaType) {
        this.vendorType = mediaType;
    }

    @Override
    public long getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public void setVersionNumber(long versionNumber) {
        this.versionNumber = versionNumber;
    }
}

