/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.NamespaceManager;
import io.konig.core.impl.MemoryNamespaceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.openrdf.model.Namespace;

public class CompositeNamespaceManager
extends MemoryNamespaceManager {
    private List<NamespaceManager> children = new ArrayList<NamespaceManager>();

    public CompositeNamespaceManager(NamespaceManager ... nsManager) {
        for (NamespaceManager ns : nsManager) {
            this.children.add(ns);
        }
    }

    public void add(NamespaceManager manager) {
        this.children.add(manager);
    }

    @Override
    public Namespace findByPrefix(String prefix) {
        Namespace ns = super.findByPrefix(prefix);
        if (ns == null) {
            for (NamespaceManager manager : this.children) {
                ns = manager.findByPrefix(prefix);
                if (ns == null) continue;
                return ns;
            }
        }
        return ns;
    }

    @Override
    public Namespace findByName(String name) {
        Namespace ns = super.findByName(name);
        if (ns == null) {
            for (NamespaceManager manager : this.children) {
                ns = manager.findByName(name);
                if (ns == null) continue;
                return ns;
            }
        }
        return ns;
    }

    @Override
    public NamespaceManager add(Namespace ns) {
        super.add(ns);
        return this;
    }

    @Override
    public NamespaceManager add(String prefix, String namespace) {
        super.add(prefix, namespace);
        return this;
    }

    @Override
    public Collection<Namespace> listNamespaces() {
        HashSet<Namespace> set = new HashSet<Namespace>();
        set.addAll(super.listNamespaces());
        for (NamespaceManager manager : this.children) {
            Collection<Namespace> collection = manager.listNamespaces();
            set.addAll(collection);
        }
        return set;
    }
}

