/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Context;
import io.konig.core.Term;
import java.util.List;
import org.openrdf.model.impl.URIImpl;

public class ContextTransformService {
    private static final int MAX_SUFFIX = 100;

    public void append(Context source, Context target) {
        List<Term> list = source.asList();
        source.compile();
        Context sourceInverse = null;
        Context targetInverse = target.inverse();
        block0: for (Term term : list) {
            String key = term.getKey();
            String value = term.getExpandedIdValue();
            if (targetInverse.getTerm(value) != null) continue;
            Term other = target.getTerm(key);
            if (other == null) {
                target.add(new Term(key, value, term.getKind()));
                continue;
            }
            URIImpl uri = new URIImpl(value);
            String namespace = uri.getNamespace();
            if (sourceInverse == null) {
                sourceInverse = source.inverse();
            }
            String localName = uri.getLocalName();
            Term namespaceTerm = sourceInverse.getTerm(namespace);
            if (namespaceTerm != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(namespaceTerm.getKey());
                builder.append('_');
                builder.append(localName);
                String newKey = builder.toString();
                Term newOther = target.getTerm(newKey);
                if (newOther == null) {
                    target.add(new Term(newKey, value, term.getKind()));
                    continue;
                }
            }
            for (int suffix = 1; suffix < 100; ++suffix) {
                StringBuilder builder = new StringBuilder(localName);
                builder.append(suffix);
                String newKey = builder.toString();
                if (target.getTerm(newKey) != null) continue;
                target.add(new Term(newKey, value, term.getKind()));
                continue block0;
            }
        }
    }
}

