/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.impl.DagVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class Dag {
    private Map<Resource, DagVertex> map = new HashMap<Resource, DagVertex>();

    public void addEdge(Resource subject, Resource object) {
        this.addEdge(this.vertex(subject), this.vertex(object));
    }

    public void addEdge(DagVertex subject, DagVertex object) {
        subject.getOutward().add(object);
        object.getInward().add(subject);
    }

    public void removeEdge(DagVertex subject, DagVertex object) {
        if (subject != null && object != null) {
            subject.getOutward().remove(object);
            object.getInward().remove(subject);
            if (subject.getOutward().isEmpty() && subject.getInward().isEmpty()) {
                this.map.remove(subject.getId());
            }
            if (object.getOutward().isEmpty() && object.getInward().isEmpty()) {
                this.map.remove(object.getId());
            }
        }
    }

    public DagVertex vertex(Resource id) {
        DagVertex v = this.map.get(id);
        if (v == null) {
            v = new DagVertex(id);
            this.map.put(id, v);
        }
        return v;
    }

    public List<Resource> sort() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        List<DagVertex> stack = this.startNodes();
        while (!stack.isEmpty()) {
            DagVertex subject = stack.remove(stack.size() - 1);
            result.add(subject.getId());
            ArrayList<DagVertex> out = new ArrayList<DagVertex>(subject.getOutward());
            for (DagVertex object : out) {
                this.removeEdge(subject, object);
                if (!object.getInward().isEmpty()) continue;
                stack.add(object);
            }
        }
        if (!this.map.isEmpty()) {
            throw new KonigException("The supplied graph is not a directed acyclic graph");
        }
        return result;
    }

    private List<DagVertex> startNodes() {
        ArrayList<DagVertex> set = new ArrayList<DagVertex>();
        for (DagVertex v : this.map.values()) {
            if (!v.getInward().isEmpty()) continue;
            set.add(v);
        }
        return set;
    }

    public static Dag create(Graph graph, URI predicate) {
        Dag dag = new Dag();
        for (Edge e : graph) {
            if (!predicate.equals((Object)e.getPredicate())) continue;
            Resource subject = e.getSubject();
            if (!(e.getObject() instanceof Resource)) {
                throw new KonigException("Invalid Kahn graph with predicate <" + predicate + ">.  Object must be a resource.");
            }
            Resource object = (Resource)e.getObject();
            DagVertex s = dag.vertex(subject);
            DagVertex o = dag.vertex(object);
            o.getInward().add(s);
            s.getOutward().add(o);
        }
        return dag;
    }
}

