/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Edge;
import io.konig.core.ValueSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;

public class EdgeImpl
extends ContextStatementImpl
implements Edge {
    private static final long serialVersionUID = 1L;
    private HashMap<URI, Value> properties;

    public EdgeImpl(Resource subject, URI predicate, Value object) {
        super(subject, predicate, object, null);
    }

    public EdgeImpl(Resource subject, URI predicate, Value object, Resource context) {
        super(subject, predicate, object, context);
    }

    public EdgeImpl(Edge other) {
        super(other.getSubject(), other.getPredicate(), other.getObject(), other.getContext());
    }

    @Override
    public Value getAnnotation(URI predicate) {
        Value value;
        Value value2 = value = this.properties == null ? null : this.properties.get(predicate);
        if (value instanceof ValueSet) {
            ValueSet set = (ValueSet)value;
            if (set.isEmpty()) {
                value = null;
            } else if (set.size() == 1) {
                value = set.iterator().next();
            }
        }
        return value;
    }

    @Override
    public Edge setAnnotation(URI predicate, Value value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<URI, Value>();
        }
        this.properties.put(predicate, value);
        return this;
    }

    @Override
    public Value removeAnnotation(URI predicate) {
        return this.properties == null ? null : this.properties.remove(predicate);
    }

    @Override
    public void copyAnnotations(Edge edge) {
        if (this.properties != null) {
            Set<Map.Entry<URI, Value>> set = this.properties.entrySet();
            for (Map.Entry<URI, Value> e : set) {
                edge.setAnnotation(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public ValueSet getAnnotationSet(URI predicate) {
        Object result = this.getAnnotation(predicate);
        if (!(result instanceof ValueSet)) {
            ValueSet set = new ValueSet();
            if (result != null) {
                set.add((Value)result);
            }
            result = set;
        }
        return (ValueSet)result;
    }

    @Override
    public Edge addAnnotation(URI predicate, Value value) {
        ValueSet set = null;
        Value result = this.getAnnotation(predicate);
        if (result instanceof ValueSet) {
            set = (ValueSet)result;
        } else {
            if (result == null) {
                this.setAnnotation(predicate, value);
                return this;
            }
            set = new ValueSet();
            set.add(result);
            this.setAnnotation(predicate, (Value)set);
        }
        set.add(value);
        return this;
    }

    @Override
    public boolean matches(Value a, Value b) {
        if (a instanceof ValueSet) {
            ValueSet set = (ValueSet)a;
            return set.contains(b);
        }
        if (b instanceof ValueSet) {
            ValueSet set = (ValueSet)b;
            return set.contains(a);
        }
        return a.equals(b);
    }
}

