/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Vertex;
import java.util.Iterator;
import java.util.Set;

public class EdgeIterator
implements Iterator<Edge> {
    private Iterator<Vertex> vertexIterator;
    private Iterator<Edge> edgeIterator;

    public EdgeIterator(Graph graph) {
        this.vertexIterator = graph.vertices().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.edgeIterator == null) {
            while (this.vertexIterator.hasNext()) {
                Vertex v = this.vertexIterator.next();
                this.edgeIterator = v.outEdgeSet().iterator();
                if (!this.edgeIterator.hasNext()) continue;
                return true;
            }
        } else {
            if (this.edgeIterator.hasNext()) {
                return true;
            }
            while (this.vertexIterator.hasNext()) {
                Vertex v = this.vertexIterator.next();
                Set<Edge> set = v.outEdgeSet();
                this.edgeIterator = set.iterator();
                if (!this.edgeIterator.hasNext()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Edge next() {
        return this.edgeIterator.next();
    }

    @Override
    public void remove() {
        this.edgeIterator.remove();
    }
}

