/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.NamespaceManager;
import java.util.ArrayList;
import java.util.Collection;
import org.openrdf.model.Namespace;

public class LinkedNamespaceManager
implements NamespaceManager {
    private NamespaceManager first;
    private NamespaceManager rest;

    public LinkedNamespaceManager(NamespaceManager first, NamespaceManager rest) {
        this.first = first;
        this.rest = rest;
    }

    @Override
    public Namespace findByPrefix(String prefix) {
        Namespace ns = this.first.findByPrefix(prefix);
        if (ns == null) {
            ns = this.rest.findByPrefix(prefix);
        }
        return ns;
    }

    @Override
    public Namespace findByName(String name) {
        Namespace ns = this.first.findByName(name);
        if (ns == null) {
            ns = this.rest.findByName(name);
        }
        return ns;
    }

    @Override
    public NamespaceManager add(Namespace ns) {
        this.first.add(ns);
        return this;
    }

    @Override
    public NamespaceManager add(String prefix, String namespace) {
        this.first.add(prefix, namespace);
        return this;
    }

    @Override
    public Collection<Namespace> listNamespaces() {
        ArrayList<Namespace> list = new ArrayList<Namespace>(this.first.listNamespaces());
        for (Namespace ns : this.rest.listNamespaces()) {
            String name = ns.getName();
            if (this.first.findByName(name) != null) continue;
            list.add(ns);
        }
        return list;
    }
}

