/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Context;
import io.konig.core.ContextManager;
import io.konig.core.impl.ContextTransformService;
import io.konig.core.io.ContextReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryContextManager
implements ContextManager {
    private static final Logger logger = LoggerFactory.getLogger(MemoryContextManager.class);
    private static final String CLASSPATH_MANIFEST = "jsonld/context.properties";
    private static Long versionSequence = 1L;
    private Map<String, Context> map = new HashMap<String, Context>();
    private Map<String, Context> byMediaType = new HashMap<String, Context>();
    private Map<Long, Context> byVersionNumber = new HashMap<Long, Context>();
    private Context summary;
    private ContextTransformService transformer;

    public MemoryContextManager(Context summary) {
        this.summary = summary;
    }

    public MemoryContextManager() {
    }

    @Override
    public Context getContextByURI(URI contextURI) {
        return this.map.get(contextURI.stringValue());
    }

    @Override
    public Context getContextByURI(String contextURI) {
        return this.map.get(contextURI);
    }

    @Override
    public void add(Context context) {
        String vendorType;
        this.map.put(context.getContextIRI(), context);
        if (context.getVersionNumber() < 1L) {
            Long l = versionSequence;
            Long l2 = versionSequence = Long.valueOf(versionSequence + 1L);
            context.setVersionNumber(l);
        }
        if ((vendorType = context.getVendorType()) != null) {
            this.byMediaType.put(vendorType, context);
        }
        this.byVersionNumber.put(context.getVersionNumber(), context);
        if (this.summary != null) {
            if (this.transformer == null) {
                this.transformer = new ContextTransformService();
            }
            this.transformer.append(context, this.summary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromClasspath() throws IOException {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(CLASSPATH_MANIFEST);
        try {
            if (input != null) {
                Properties properties = new Properties();
                properties.load(input);
                ContextReader contextReader = new ContextReader();
                for (Object key : properties.keySet()) {
                    String path = "jsonld/" + (String)key;
                    String contextId = properties.getProperty(key.toString());
                    InputStream contextInput = this.getClass().getClassLoader().getResourceAsStream(path);
                    try {
                        Context context = contextReader.read(contextInput);
                        logger.debug("Loaded context {}", (Object)contextId);
                        if (context.getContextIRI() == null) {
                            context.setContextIRI(contextId);
                        }
                        this.add(context);
                    }
                    catch (Throwable ignore) {
                        logger.debug("Failed to load context " + contextId, ignore);
                    }
                    finally {
                        this.close(contextInput);
                    }
                }
            }
        }
        finally {
            this.close(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File source) throws IOException {
        block6: {
            block5: {
                File[] kids;
                if (!source.isDirectory()) break block5;
                for (File file : kids = source.listFiles()) {
                    this.loadFromFile(file);
                }
                break block6;
            }
            String name = source.getName();
            if (!name.endsWith(".json") && !name.endsWith(".jsonld")) break block6;
            ContextReader reader = new ContextReader();
            FileInputStream input = new FileInputStream(source);
            try {
                Context context = reader.read(input);
                if (context.getContextIRI() != null) {
                    this.add(context);
                }
                logger.warn("Ignoring JSON-LD context because it does not have an @id value: " + source.getAbsolutePath());
            }
            finally {
                this.close(input);
            }
        }
    }

    private void close(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public List<String> listContexts() {
        return new ArrayList<String>(this.map.keySet());
    }

    @Override
    public Context getContextByMediaType(String mediaType) {
        return this.byMediaType.get(mediaType);
    }

    @Override
    public Context getContextByVersionNumber(long versionNumber) {
        return this.byVersionNumber.get(versionNumber);
    }

    @Override
    public Context getUniversalContext() {
        return this.summary;
    }
}

